% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aou_ls.R
\name{aou_ls_bucket}
\alias{aou_ls_bucket}
\title{List the current files in your bucket}
\usage{
aou_ls_bucket(
  pattern = "",
  silent = FALSE,
  recursive = TRUE,
  bucket = getOption("aou.default.bucket"),
  gsutil_args = ""
)
}
\arguments{
\item{pattern}{Regular expression, such as "*.csv" or a single file name
e.g., "mydata.csv". Default will find all files apart from notebooks
(.ipynb files).}

\item{silent}{Whether to omit the names of files found. Defaults to \code{FALSE}.}

\item{recursive}{Whether to search subdirectories. Defaults to \code{TRUE}.}

\item{bucket}{Bucket to retrieve file from. Defaults to
\code{getOption("aou.default.bucket")}, which is
\code{Sys.getenv('WORKSPACE_BUCKET')} unless specified otherwise.}

\item{gsutil_args}{A string containing other arguments passed to \verb{gsutil ls}.
See \url{https://cloud.google.com/storage/docs/gsutil/commands/ls} for details.}
}
\value{
A vector of file names
}
\description{
Lists all files in the bucket or files matching a certain
pattern.
}
\examples{
\dontshow{if (on_workbench()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# list all files, including in subdirectories
aou_ls_bucket()
# list all csv files
aou_ls_bucket("*.csv")
\dontshow{\}) # examplesIf}
}
