% Generated by roxygen2 (4.0.1): do not edit by hand
\name{simFams}
\alias{simFams}
\title{Generation of a group of simulated families}
\usage{
simFams(nfams = 2, nMarkers = 6, numAllperMrk = NULL, chrAlleles = TRUE,
  nHaplos = 1200, missParProb = 0, missOffProb = 0, pAff = 0.2,
  recombRate = 0)
}
\arguments{
\item{nfams}{Number of families to generate (integer: 1..10000+)}

\item{nMarkers}{Number of markers or allele pairs to generate (integer: 1..7+)}

\item{numAllperMrk}{Number of different alleles per marker (vector or NULL)}

\item{chrAlleles}{Should alleles be expressed as characters A,C,G,T ? (boolean: FALSE, TRUE)}

\item{nHaplos}{Number of different haplotypes in the population (numeric)}

\item{missParProb}{Probability of parents' missing genotype (numeric: 0..1)}

\item{missOffProb}{Probability of offspring missing genotype (numeric: 0..1)}

\item{pAff}{Probability of being affected by disease (numeric: 0..1)}

\item{recombRate}{Recombination rate (numeric: 0..1)}
}
\value{
family alleles dataframe
}
\description{
Database simulation can be performed taking into account many different factors such as number of families to generate, number of markers (allele pairs), number of different alleles per marker, type of alleles (numeric or character), number of different haplotypes in the population, probability of parent/offspring missing genotypes, probability of being affected by disease and recombination rate.
}
\examples{
## Generation of 100 simulated families with 12 markers
dataset <- simFams(100,12)         # Creates a list with simulated alleles and haplotypes
datasetAlls <- dataset[[1]]        # Extracts familiar alleles
datasetHaps <- dataset[[2]]        # Extracts familiar haplotypes

## Not run:
# nMarkers>=15 and chrAlleles=TRUE   (May cause repetition in the allelic generation)
# nMarkers>=25 and chrAlleles=FALSE  (May cause repetition in the allelic generation)
}
\references{
Medina-Rodriguez, N. Santana A. et al. (2014) alleHap: an efficient algorithm to reconstruct zero-recombinant haplotypes from parent-offspring pedigrees. BMC Bioinformatics, 15, A6 (S-3).
}

