% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ale_core.R
\name{ale_core}
\alias{ale_core}
\title{Create and return ALE data and plots}
\usage{
ale_core(
  test_data,
  model,
  ixn,
  x_cols = NULL,
  x1_cols = NULL,
  x2_cols = NULL,
  output = c("plot", "data"),
  pred_fun = function(object, newdata) {
     stats::predict(object = object, newdata =
    newdata, type = predict_type)
 },
  predict_type = "response",
  x_intervals = 100,
  boot_it = 0,
  seed = 0,
  boot_alpha = 0.05,
  boot_centre = "median",
  relative_y = "median",
  y_type = NULL,
  plot_alpha = 0.05,
  ale_xs = NULL,
  ale_ns = NULL,
  n_x1_int = 20,
  n_x2_int = 20,
  n_y_quant = 10
)
}
\arguments{
\item{test_data}{See documentation for \code{ale}}

\item{model}{See documentation for \code{ale}}

\item{ixn}{logical. If TRUE, \code{ale_core} will return interaction data between \code{x1_cols}
and \code{x2_cols}; both must be provided; \code{x_cols} will be ignored.
If FALSE (default), only one-way ALE data
of \code{x_cols} (required in that case) will be created; \code{x1_cols} and \code{x2_cols} will
be ignored.}

\item{x_cols}{See documentation for \code{ale}}

\item{x1_cols, x2_cols}{See documentation for \code{ale_ixn}}

\item{output}{See documentation for \code{ale}}

\item{pred_fun, predict_type}{See documentation for \code{ale}}

\item{x_intervals}{See documentation for \code{ale}}

\item{boot_it}{See documentation for \code{ale}}

\item{seed}{See documentation for \code{ale}}

\item{boot_alpha}{See documentation for \code{ale}}

\item{boot_centre}{See documentation for \code{ale}}

\item{relative_y}{See documentation for \code{ale}}

\item{y_type}{See documentation for \code{ale}}

\item{plot_alpha}{See documentation for \code{ale}}

\item{ale_xs}{See documentation for \code{ale}}

\item{ale_ns}{See documentation for \code{ale}}

\item{n_x1_int, n_x2_int}{See documentation for \code{ale_ixn}}

\item{n_y_quant}{See documentation for \code{ale_ixn}}
}
\description{
Not exported. This is the central function that manages the creation of ALE data and plots,
both for one-way ALE and two-way interactions. This function does not do the
actual creation of the data or plots. It receives user inputs, preprocesses them,
and then calls the appropriate functions to create the ALE data and plots.
As such, this function is not normally directly called by users. So, the
documentation details for each variable here is specified in the user-facing
function that specifies it.
}
