% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PointMap.R
\docType{methods}
\name{connections,PointMap-method}
\alias{connections,PointMap-method}
\title{Get the PointMap connections}
\usage{
\S4method{connections}{PointMap}(map)
}
\arguments{
\item{map}{A PointMap}
}
\value{
A matrix with the connected refs
}
\description{
Get the PointMap connections
}
\examples{
mifFile <- system.file(
    "extdata", "testdata", "gallery",
    "gallery_lines.mif",
    package = "alcyon"
  )
  sfMap <- st_read(mifFile,
    geometry_column = 1L, quiet = TRUE
  )
  pointMap <- makeVGAPointMap(
    sfMap,
    gridSize = 0.04,
    fillX = 3.01,
    fillY = 6.7,
    maxVisibility = NA,
    boundaryGraph = FALSE,
    verbose = FALSE
  )
connections(pointMap)
}
