% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sequence.R
\name{junctionAlignment}
\alias{junctionAlignment}
\title{Calculate junction region alignment properties}
\usage{
junctionAlignment(
  data,
  germline_db,
  v_call = "v_call",
  d_call = "d_call",
  j_call = "j_call",
  v_germline_start = "v_germline_start",
  v_germline_end = "v_germline_end",
  d_germline_start = "d_germline_start",
  d_germline_end = "d_germline_end",
  j_germline_start = "j_germline_start",
  j_germline_end = "j_germline_end",
  np1_length = "np1_length",
  np2_length = "np2_length",
  junction = "junction",
  junction_length = "junction_length",
  sequence_alignment = "sequence_alignment"
)
}
\arguments{
\item{data}{\code{data.frame} containing sequence data.}

\item{germline_db}{reference germline database for the V, D and J genes.
in \code{data}}

\item{v_call}{V gene assignment column.}

\item{d_call}{D gene assignment column.}

\item{j_call}{J gene assignment column.}

\item{v_germline_start}{column containing the start position of the alignment 
in the V reference germline.}

\item{v_germline_end}{column containing the end position of the alignment in the 
V reference germline.}

\item{d_germline_start}{column containing the start position of the alignment 
in the D reference germline.}

\item{d_germline_end}{column containing the start position of the alignment 
in the D reference germline.}

\item{j_germline_start}{column containing the start position of the alignment 
in the J reference germline.}

\item{j_germline_end}{column containing the start position of the alignment 
in the J reference germline.}

\item{np1_length}{combined length of the N and P regions between the 
V and D regions (heavy chain) or V and J regions (light chain).}

\item{np2_length}{combined length of the N and P regions between the 
D and J regions (heavy chain).}

\item{junction}{column containing the junction sequence.}

\item{junction_length}{column containing the length of the junction region in nucleotides.}

\item{sequence_alignment}{column containing the aligned sequence.}
}
\value{
A modified input \code{data.frame} with the following additional columns storing 
         junction alignment information:
         \enumerate{
             \item  \code{e3v_length}:     number of 3' V germline nucleotides deleted.
             \item  \code{e5d_length}:     number of 5' D germline nucleotides deleted.
             \item  \code{e3d_length}:     number of 3' D germline nucleotides deleted.
             \item  \code{e5j_length}:     number of 5' J germline nucleotides deleted.
             \item  \code{v_cdr3_length}:  number of sequence_alignment V nucleotides in the CDR3.
             \item  \code{j_cdr3_length}:  number of sequence_alignment J nucleotides in the CDR3.
         }
}
\description{
\code{junctionAlignment} determines the number of deleted germline nucleotides in the 
junction region and the number of V gene and J gene nucleotides in the CDR3.
}
\examples{
germline_db <- list(
"IGHV3-11*05"="CAGGTGCAGCTGGTGGAGTCTGGGGGA...GGCTTGGTCAAGCCTGGAGGGTCCCTGAGACT
CTCCTGTGCAGCCTCTGGATTCACCTTC............AGTGACTACTACATGAGCTGGATCCGCCAGGCTCCAG
GGAAGGGGCTGGAGTGGGTTTCATACATTAGTAGTAGT......AGTAGTTACACAAACTACGCAGACTCTGTGAAG
...GGCCGATTCACCATCTCCAGAGACAACGCCAAGAACTCACTGTATCTGCAAATGAACAGCCTGAGAGCCGAGGA
CACGGCCGTGTATTACTGTGCGAGAGA",
"IGHD3-10*01"="GTATTACTATGGTTCGGGGAGTTATTATAAC",
"IGHJ5*02"="ACAACTGGTTCGACCCCTGGGGCCAGGGAACCCTGGTCACCGTCTCCTCAG"
)

db <- junctionAlignment(SingleDb, germline_db)

}
