% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{pkappa4}
\alias{pkappa4}
\alias{dkappa4}
\alias{qkappa4}
\alias{rkappa4}
\alias{dddkappa4}
\alias{kappa4cond}
\alias{kappa4tc}
\title{Four-parameter kappa distribution.}
\usage{
pkappa4(x, mu, sigma, h, k)

dkappa4(x, mu, sigma, h, k)

qkappa4(x, mu, sigma, h, k)

rkappa4(n, mu, sigma, h, k)

dddkappa4(x, mu, sigma, h, k)

kappa4cond(mu, sigma, h, k)

kappa4tc(h, mu, sigma)
}
\arguments{
\item{x}{A data point, or quantile, at which the four-parameter kappa distribution should be evaluated.}

\item{mu}{A real value representing the location of the distribution.}

\item{sigma}{A positive real number representing the scale parameter of the distribution.}

\item{h, k}{Real numbers representing shape parameters of the distribution.}

\item{n}{Number of random variates to generate.}
}
\value{
pkappa4: The cumulative distribution function at the point \code{x}.

dkappa4: The density function at the point x.

qkappa4: The \code{x}th quantile of the distribution.

rkappa4: Randomly generated numbers from the distribution.

dddkappa4: The second derivative of dkappa4.

kappa4cond: The resultant induction period (IP).

kappa4tc: A list with the following components:
\itemize{
\item $par: The k shape parameter corresponding to a given h parameter for the time-conductivity problem.
\item $abstol: The absolute tolerance for the numerical optimisation.
\item $fail: A code relating to the optimisation routine.
\item $fncount: Number of function calls.
}
}
\description{
Functions for the four-parameter kappa distribution.
}
\examples{
pkappa4(1, 1, 2, 0.5, 2)
dkappa4(1, 1, 2, 0.5, 2)
qkappa4(0.25, 1, 2, 0.5, 2)
rkappa4(10, 1, 2, 0.5, 2)
dddkappa4(1, 1, 2, 0.5, 2)
kappa4cond(1, 2, 0.5, 2)
kappa4tc(-4, 0, 1)
}
