% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_akstats.R
\name{print_akstats}
\alias{print_akstats}
\title{Descriptive (Change) statistics}
\usage{
print_akstats(ak_object, k = 3, reference = 1, n_quant = 4, show_plots = FALSE)
}
\arguments{
\item{ak_object}{An output of \code{\link{akclustr}} function.
The object contains individual trajectories and their cluster
solution(s) at the specified values of \code{k}. Also, includes
the optimal value of \code{k} based on the criterion specified.
at (different) values of \code{k} the \code{traj}.}

\item{k}{[integer] \code{k} cluster to generate its solution.}

\item{reference}{[numeric] Specifying the reference line from
which the direction of each group is measured. Options are:
\code{1}: slope of mean trajectory, \code{2}: slope of medoid
trajectory, \code{3}: slope of a horizontal line
(i.e. slope = 0). Default: \code{1}.}

\item{n_quant}{[numeric] Number of equal intervals (quantiles)
to create between the reference line \code{(R)} and the medoids
\code{(M)} of the most-diverging groups of both sides of
\code{(R)}. Default is \code{4} - meaning quartile subdivisions
on each side of \code{(R)}. In this scenario, the function
returns the quartile in which the medoid of each group falls.
This result can be used to further categorize the groups into
'classes'. For example, groups that fall within the \code{1st}
quartile may be classified as 'Stable' groups (Adepeju et al. 2021).}

\item{show_plots}{[TRUE or FALSE] Provides the trajectory group
plot. Please, see \code{plot_akstats} function for more
plot options.
Defaults \code{FALSE}}
}
\value{
A plot showing group membership or sizes (proportion)
and statistics.
}
\description{
This function perform two tasks:
(i) it generate the descriptive and change statistics
of groups, particularly suited for the outputs form
the \code{\link{akclustr}} function, and
(ii) generates the plots of the groups (performances).
}
\details{
Generates the plot of trajectory groupings.
Given an \code{ak_object} class (from
the \code{akclustr} function), this function show the
plots of cluster groups. The plot component draws from
\code{plot_akstats} function.
}
\examples{

data(traj)

trajectry <- data_imputation(traj, id_field = TRUE, method = 1,
replace_with = 1, fill_zeros = FALSE)

print(trajectry$CompleteData)

trajectry <- props(trajectry$CompleteData, id_field = TRUE)

aksolution <- akclustr(trajectry, id_field = TRUE,
    method = "linear", k = c(3,5), crit='Calinski_Harabasz')

print_akstats(aksolution, k = 4, show_plots=FALSE)

}
\references{
\code{1}. Adepeju, M. et al. (2021). Anchored k-medoids:
A novel adaptation of k-medoids further refined to measure
inequality in the exposure to crime across micro places,
doi: 10.1007/s42001-021-00103-1.

\code{2}. Wickham H. (2016). Elegant graphics for
Data Analysis. Spring-Verlag New York (2016).
}
