% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/overlap.R
\docType{methods}
\name{overlap}
\alias{overlap}
\alias{overlap-method}
\alias{overlap,TimeIntervals-method}
\title{Time Overlap}
\usage{
overlap(x, ...)

\S4method{overlap}{TimeIntervals}(x, calendar = NULL)
}
\arguments{
\item{x}{A \code{\linkS4class{TimeIntervals}} object.}

\item{...}{Currently not used.}

\item{calendar}{A \code{\linkS4class{TimeScale}} object specifying the target calendar
(see \code{\link[=calendar]{calendar()}}). If \code{NULL} (the default), \emph{rata die} are returned.}
}
\value{
A symmetric \code{numeric} \code{\link{matrix}} of years.
}
\description{
Computes the length of overlap of time intervals.
}
\details{
The overlap of two time intervals is a difference between the minimum value
of the two upper boundaries and the maximum value of the two lower
boundaries, plus 1.
}
\examples{
## Create time intervals
int <- intervals(
  start = c(625, 700, 1200, 1225, 1250, 500, 1000, 1200,
            1325, 1375, 1200, 1300, 1375, 1275, 1325),
  end = c(750, 825, 1250, 1275, 1325, 700, 1300, 1325,
          1400, 1500, 1300, 1375, 1500, 1325, 1425),
  calendar = CE()
)

## Plot intervals
plot(int) # Default calendar

## Overlap
overlap(int, calendar = CE())
}
\seealso{
Other tools: 
\code{\link{span}()},
\code{\link{start}()},
\code{\link{time}()},
\code{\link{window}()}
}
\author{
N. Frerebeau
}
\concept{tools}
