% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/convert.R
\docType{methods}
\name{convert}
\alias{convert}
\alias{convert-method}
\alias{convert,character,character-method}
\alias{convert,TimeScale,TimeScale-method}
\title{Calendar Converter}
\usage{
convert(from, to, ...)

\S4method{convert}{character,character}(from, to)

\S4method{convert}{TimeScale,TimeScale}(from, to)
}
\arguments{
\item{from}{A \code{\linkS4class{TimeScale}} object describing the source calendar.}

\item{to}{A \code{\linkS4class{TimeScale}} object describing the target calendar.}

\item{...}{Currently not used.}
}
\value{
A \code{\link{function}} that when called with a single numeric argument (factional
years) converts years from one calendar to another.
}
\description{
Interconverts dates in a variety of calendars.
}
\examples{
## Define time scales
BP <- calendar("BP")
AD <- calendar("AD")

## Make conversion functions
BP_to_AD <- convert(BP, AD)
AD_to_BP <- convert(AD, BP)

## Convert years
BP_to_AD(0)
AD_to_BP(1950)
}
\seealso{
Other calendar tools: 
\code{\link{calendar_get}},
\code{\link{calendar}()},
\code{\link{gregorian}},
\code{\link{is}()},
\code{\link{julian}()}
}
\author{
N. Frerebeau
}
\concept{calendar tools}
