% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_optimaldecision.R
\name{PlotOptimalDecision}
\alias{PlotOptimalDecision}
\title{Plot optimal decision}
\usage{
PlotOptimalDecision(res, colname.d, idx = NULL)
}
\arguments{
\item{res}{The data frame generated from \code{CalOptimalDecision}.}

\item{colname.d}{The column name of decision to be plotted.}

\item{idx}{The row index of observations to be included. The default is all the observations from the data.}
}
\value{
A ggplot.
}
\description{
See Figure 6 for example.
}
\examples{
\donttest{
data(synth)
sample_mcmc = AiEvalmcmc(data = synth, n.mcmc = 10)
sample_optd = CalOptimalDecision(data = synth, mcmc.re = sample_mcmc, 
                                 c0.ls = seq(0,5,1), c1.ls = seq(0,5,1), 
                                 size = 1) # adjust the size
sample_optd$cash = sample_optd$d1 + sample_optd$d2 + sample_optd$d3
PlotOptimalDecision(sample_optd, "cash")
}

}
