% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_fct.R
\name{check_embedding_models}
\alias{check_embedding_models}
\title{Check of compatible text embedding models}
\usage{
check_embedding_models(object_list, same_class = FALSE)
}
\arguments{
\item{object_list}{\code{list} of object of class \link{EmbeddedText} or
\link{TextEmbeddingClassifierNeuralNet}.}

\item{same_class}{\code{bool} \code{TRUE} if all object must be from the same class.}
}
\value{
Returns \code{TRUE} if all objects refer to the same text embedding model.
\code{FALSE} in all other cases.
}
\description{
This function checks if different objects are based on the same text
embedding model. This is necessary to ensure that classifiers are used
only with data generated through compatible embedding models.
}
\seealso{
Other Auxiliary Functions: 
\code{\link{array_to_matrix}()},
\code{\link{calc_standard_classification_measures}()},
\code{\link{clean_pytorch_log_transformers}()},
\code{\link{create_iota2_mean_object}()},
\code{\link{create_synthetic_units}()},
\code{\link{generate_id}()},
\code{\link{get_coder_metrics}()},
\code{\link{get_folds}()},
\code{\link{get_n_chunks}()},
\code{\link{get_stratified_train_test_split}()},
\code{\link{get_synthetic_cases}()},
\code{\link{get_train_test_split}()},
\code{\link{is.null_or_na}()},
\code{\link{matrix_to_array_c}()},
\code{\link{split_labeled_unlabeled}()},
\code{\link{summarize_tracked_sustainability}()},
\code{\link{to_categorical_c}()}
}
\concept{Auxiliary Functions}
\keyword{internal}
