% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{city200}
\alias{city200}
\title{A dataframe of 200 simulated decision-makers based on \insertCite{Saaty2004;textual}{ahpsurvey}}
\format{A \code{data.frame} with 200 row and 10 variables, which are pairwise comparisons of \code{atts}.}
\source{
\insertAllCited{}
}
\usage{
data(city200)
}
\description{
A data.frame of one decision-maker with weights the same as \insertCite{Saaty2004;textual}{ahpsurvey}, with the pairwise comparisons of \code{atts}: \code{c('cult', 'fam', 'house', 'jobs', 'trans')}, about a choosing the best city to live in based on five attributes: Culture, Family, House, Jobs, and Transportation. The choices of 200 decision-makers are simulated based on the underlying weights and randomness generated by a normal random distribution. The true weights are stored in \code{data(city1)}. The normal random distribution was set with a mean at the true weight value and a standard deviation of \verb{2,1,2,1.5,2,1.5,2.5,0.5,0.5,1} in chronological order of the columns in \code{city200}.
}
\keyword{datasets}
