% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{plot_split_lsd}
\alias{plot_split_lsd}
\title{Plot Split Plot Design lsd}
\usage{
plot_split_lsd(
  design,
  factor_name_1 = "T1",
  factor_name_2 = "T2",
  labels = "plots",
  subplots = TRUE,
  width = 1,
  height = 1,
  space_width = 0.95,
  space_height = 0.85,
  reverse_y = FALSE,
  reverse_x = FALSE
)
}
\arguments{
\item{design}{outdesign from \code{agricolae} package}

\item{factor_name_1}{string Which factor should be used for plotting, needs to be a column in outdesign$book}

\item{factor_name_2}{string Which factor should be used for plotting, needs to be a column in outdesign$book}

\item{labels}{string Describes the column from that the plots are taken to display them}

\item{subplots}{should the plot function return the subplots (default) or main plots?}

\item{width}{numeric value, describes the width of a plot in an experiment}

\item{height}{numeric value, describes the height of a plot in an experiment}

\item{space_width}{numeric value, describes the share of the space of the plots. 0=only space, 1=no space between plots in term of width}

\item{space_height}{numeric value, describes the share of the space of the plots. 0=only space, 1=no space between plots in term of height}

\item{reverse_y}{boolean, should the plots of the experiment be changed in reverse order in Row direction? use reverse_y=TRUE to have same sketch as in agricolae. default:reverse_y=FALSE}

\item{reverse_x}{boolean, should the plots of the experiment be changed in reverse order in column direction? default:reverse_x=FALSE}
}
\value{
\code{ggplot} graphic that can be modified, if wished
}
\description{
Plot a design of a split plot experiment with latin squared design (lsd) from design.split
}
\examples{
library(agricolaeplotr)
library(agricolae)
T1<-c('a','b','c','d','e')
T2<-c('v','w','x','y')
outdesign2 <- design.split(trt1=T1, trt2=T2, r=r,serie = 2,
                           seed = 0, kinds = 'Super-Duper',
                           randomization=TRUE,first=TRUE,design = 'lsd')
plot_split_lsd(outdesign2,width = 4,height = 4)
}
