% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00-misc-support-functions.R
\name{default_control_marglaplace}
\alias{default_control_marglaplace}
\title{Default control arguments for \code{aghq::marginal_laplace()}.}
\usage{
default_control_marglaplace(...)
}
\arguments{
\item{...}{You can provide a named value for any control parameter and its
value will be set accordingly. See \code{?marginal_laplace} and examples here.}
}
\value{
A list of argument values.
}
\description{
Run \code{default_control_marglaplace()} to print the list of valid control parameters
and their defaults, and run with named arguments to change the defaults.
}
\details{
Valid options are:
\itemize{
\item{\code{method}: }{optimization method to use for the \code{theta} optimization:
\itemize{
\item{'sparse_trust' (default): }{\code{trustOptim::trust.optim}}
\item{'sparse': }{\code{trust::trust}}
\item{'BFGS': }{\code{optim(...,method = "BFGS")}}
}
}
\item{\code{inner_method}: }{optimization method to use for the \code{W} optimization; same
options as for \code{method}. Default \code{inner_method} is 'sparse_trust' and default \code{method} is 'BFGS'.
}
\item \code{negate}: default \code{FALSE}. Multiply the functions in \code{ff} by \code{-1}?
The reason for having this option is for full compatibility with \code{TMB}:
while of course \code{TMB} allows you to code up your log-posterior any way you like,
all of its excellent features including its automatic Laplace approximation and MCMC
sampling with \code{tmbstan} assume you have coded your template to return the
\strong{negated} log-posterior. However, by default, \code{aghq} assumes you have
provided the log-posterior \strong{without negation}. Set \code{negate = TRUE} if you
have provided a template which computes the \strong{negated} log-posterior and its
derivatives. \strong{Note} that I don't expect there to be any reason to need this
argument for \code{marginal_laplace}; if you are doing a marginal Laplace approximation
using the automatic Laplace approximation provided by \code{TMB}, you should
check out \code{aghq::marginal_laplace_tmb()}.
}
}
\examples{

default_control_marglaplace()
default_control_marglaplace(method = "trust")
default_control_marglaplace(method = "trust",inner_method = "trust")
default_control_marglaplace(negate = TRUE)

}
