#' Processed data from Onset HOBO Dissolved Oxygen Data Logger.
#' A dataset containing 336 dissolved oxygen concentrations changed over time.
#' @format A data.frame with 336 rows and 13 variables:
#' \itemize{
#'   \item date_time: Date and time in POSIXct format.
#'   \item pressure_hpa: Atmospheric pressure (hpa).
#'   \item wind_ms: Wind speed (m/s).
#'   \item do: Dissolved oxygen concentrations (mg/L)
#'   \item temp: Water temperature (Celsius)
#'   \item depth: Water depth (m).
#'   \item salinity: Salinity (ppt).
#'   \item start_date_time: Start date and time of the deployment.
#'   \item end_date_time: End date and time of the deployment.
#'   \item sunrise: Sunrise time during that day.
#'   \item sunset: Sunset time during that day.
#'   \item no_hobo: Name for the data logger .
#'   \item site: Name for the site.
#' }
#' @source own data.
#' @name hobo
NULL
