% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adproclus_classes.R
\name{print.adpc}
\alias{print.adpc}
\title{Print basic information on ADPROCLUS solution}
\usage{
\method{print}{adpc}(
  x,
  title = "ADPROCLUS solution",
  digits = 3,
  matrix_rows = 10,
  matrix_cols = 15,
  ...
)
}
\arguments{
\item{x}{ADPROCLUS solution (class: \code{adpc})}

\item{title}{String. Default: "ADPROCLUS solution"}

\item{digits}{Integer. The number of digits that all decimal numbers will
be rounded to.}

\item{matrix_rows}{Integer. The number of matrix rows to display. OPTIONAL}

\item{matrix_cols}{Integer. The number of matrix columns to display. OPTIONAL}

\item{...}{ignored}
}
\value{
No return value, called for side effects.
}
\description{
For an object of class \code{adpc} as input, this method prints basic
information about the ADPROCLUS solution represented by the object.
Works for both full and low dimensional solutions. Adjust the parameters
\code{digits, matrix_rows, matrix_cols}
to change the level of detail printed.
}
\examples{
# Obtain data, compute model, print model
x <- stackloss
model <- adproclus(x, 3)
print(model)
}
