% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataDistribution.R
\docType{class}
\name{DataDistribution-class}
\alias{DataDistribution-class}
\alias{DataDistribution}
\title{Data distributions}
\arguments{
\item{x}{outcome}

\item{n}{sample size}

\item{theta}{distribution parameter}

\item{...}{further optional arguments}
}
\description{
\code{DataDistribution} is an abstract class used to represent the distribution
of a sufficient statistic \code{x} given a sample size \code{n} and a
single parameter value \code{theta}.
}
\details{
This abstraction layer allows the representation of t-distributions
(unknown variance), normal distribution (known variance), and normal
approximation of a binary endpoint.
Currently, the two implemented versions are \code{\link{Normal-class}} and
\code{\link{Binomial-class}}.

The logical option \code{two_armed} allows to decide whether a one-arm or
a two-arm (the default) design should be computed. In the case of a two-arm
design all sample sizes are per group.
}
\section{Slots}{

\describe{
\item{\code{two_armed}}{Logical that indicates if a two-arm design is assumed.}
}}

\examples{
normaldist   <- Normal(two_armed = FALSE)
binomialdist <- Binomial(rate_control = .25, two_armed = TRUE)

}
