% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth.R
\name{aw_auth}
\alias{aw_auth}
\alias{auth_jwt}
\alias{auth_oauth}
\title{Generate an Access Token for the Adobe Analytics v2.0 API}
\usage{
aw_auth(type = aw_auth_with(), ...)

auth_jwt(
  file = Sys.getenv("AW_AUTH_FILE"),
  private_key = Sys.getenv("AW_PRIVATE_KEY"),
  jwt_token = NULL,
  ...
)

auth_oauth(
  client_id = Sys.getenv("AW_CLIENT_ID"),
  client_secret = Sys.getenv("AW_CLIENT_SECRET"),
  use_oob = TRUE
)
}
\arguments{
\item{type}{Either 'jwt' or 'oauth'. This can be set explicitly, but a best practice is
to run \code{aw_auth_with()} to set the authorization type as an environment variable before
running \code{aw_auth()}}

\item{...}{Additional arguments passed to auth functions.}

\item{file}{A JSON file containing service account credentials required for JWT
authentication. This file can be downloaded directly from the Adobe Console,
and should minimally have the fields \code{API_KEY}, \code{CLIENT_SECRET}, \code{ORG_ID},
and \code{TECHNICAL_ACCOUNT_ID}.}

\item{private_key}{Filename of the private key for JWT authentication.}

\item{jwt_token}{\emph{(Optional)} A custom, encoded, signed JWT claim. If used,
\code{client_id} and \code{client_secret} are still required.}

\item{client_id}{The client ID, defined by a global variable or manually defined}

\item{client_secret}{The client secret, defined by a global variable or manually defined}

\item{use_oob}{if \code{FALSE}, use a local webserver for the OAuth dance.
Otherwise, provide a URL to the user and prompt for a validation code.
Defaults to the value of the \code{httr_oob_default} default, or TRUE if
\code{httpuv} is not installed.}
}
\value{
The path of the cached token. This is returned invisibly.
}
\description{
\strong{Note:} \code{aw_auth()} is the primary function used for authorization. \code{auth_oauth()}
and \code{auth_jwt()} should typically not be called directly.
}
\section{Functions}{
\itemize{
\item \code{auth_jwt}: Authenticate with JWT token

\item \code{auth_oauth}: Authorize via OAuth 2.0
}}

\seealso{
\code{\link[=aw_auth_with]{aw_auth_with()}}
}
\concept{auth}
