% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/propose.R
\docType{data}
\name{seven_leaves_trees}
\alias{seven_leaves_trees}
\title{Seven leaves trees.}
\format{\preformatted{List of 2
 $ tree_1:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 1619 12 1637 3 12 3 1619 1637
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ tree_2:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 1639 12 1657 3 12 3 1639 1657
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
}}
\usage{
seven_leaves_trees
}
\value{
A list of functions on seven leaves.
        The outputs of these functions are \code{\link{agraph}} objects.
}
\description{
A comprehensive listing of\ldots well\ldots both unrooted trees with seven leaves.
The position of the root can be moved later with the function
\code{\link{make_an_outgroup}}.
}
\examples{
\donttest{
# While the usage of this function is pretty self-explanatory, let's plot all the graphs
# just for browsing.
for (i in seq(1, length(seven_leaves_trees))) {
  graph <- seven_leaves_trees[[i]](c("A", "B", "C", "D", "E", "F", "G"))
  # This is how you include quotation marks in strings by the way:
  title <- paste("seven_leaves_trees[[", i,
                 "]](c(\\"A\\", \\"B\\", \\"C\\", \\"D\\", \\"E\\", \\"F\\", \\"G\\"))", sep = "")
  plot(graph, color = "seagreen", title = title)
}
}
}
\seealso{
\code{\link{make_permutations}}

\code{\link{fit_permutations_and_graphs}}

\code{\link{add_a_leaf}}

\code{\link{add_an_admixture}}

\code{\link{add_an_admixture2}}

\code{\link{make_an_outgroup}}

Other graphs: \code{\link{eight_leaves_trees}};
  \code{\link{five_leaves_graphs}};
  \code{\link{four_leaves_graphs}};
  \code{\link{six_leaves_graphs}}
}
\keyword{datasets}

