% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_atirel.R
\name{derive_var_atirel}
\alias{derive_var_atirel}
\title{Derive Time Relative to Reference}
\usage{
derive_var_atirel(dataset, flag_var, new_var)
}
\arguments{
\item{dataset}{Input dataset
The variables \code{TRTSDTM}, \code{ASTDTM}, \code{AENDTM} are expected}

\item{flag_var}{Name of the variable with Analysis Start Date Imputation Flag}

\item{new_var}{Name of variable to create}
}
\value{
A dataset containing all observations and variables of the input
dataset and additionally the variable specified by the \code{new_var} parameter.
}
\description{
Derives the variable \code{ATIREL} to CONCOMITANT, PRIOR, PRIOR_CONCOMITANT or NULL
based on the relationship of cm Analysis start/end date/times to treatment start date/time
}
\details{
\code{ATIREL} is set to:
\itemize{
\item null, if Datetime of First Exposure to Treatment is missing,
\item "CONCOMITANT", if the Analysis Start Date/Time is greater than or equal to Datetime of
First Exposure to Treatment,
\item "PRIOR", if the Analysis End Date/Time is not missing and less than
the Datetime of First Exposure to Treatment,
\item "CONCOMITANT" if the date part of Analysis Start Date/Time is equal to
the date part of Datetime of First Exposure to Treatment and
the Analysis Start Time Imputation Flag is 'H' or 'M',
\item otherwise it is set to "PRIOR_CONCOMITANT".
}
}
\examples{
library(dplyr, warn.conflicts = FALSE)
adcm <- tibble::tribble(
  ~STUDYID, ~USUBJID, ~TRTSDTM, ~ASTDTM, ~AENDTM, ~ASTTMF,
  "TEST01", "PAT01", "2012-02-25 23:00:00", "2012-02-28 19:00:00", "2012-02-25 23:00:00", "",
  "TEST01", "PAT01", "", "2012-02-28 19:00:00", "", "",
  "TEST01", "PAT01", "2017-02-25 23:00:00", "2013-02-25 19:00:00", "2014-02-25 19:00:00", "",
  "TEST01", "PAT01", "2017-02-25 16:00:00", "2017-02-25 14:00:00", "2017-03-25 23:00:00", "m",
  "TEST01", "PAT01", "2017-02-25 16:00:00", "2017-02-25 14:00:00", "2017-04-29 14:00:00", ""
) \%>\% dplyr::mutate(
  TRTSDTM = lubridate::as_datetime(TRTSDTM),
  ASTDTM = lubridate::as_datetime(ASTDTM),
  AENDTM = lubridate::as_datetime(AENDTM)
)

derive_var_atirel(
  dataset = adcm,
  flag_var = ASTTMF,
  new_var = ATIREL
)

}
\author{
Teckla Akinyi
}
\keyword{ADaM}
\keyword{ATIREL}
\keyword{Relationship}
\keyword{Var}
