% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_vars_aage.R
\name{derive_var_agegr_fda}
\alias{derive_var_agegr_fda}
\alias{derive_var_agegr_ema}
\title{Derive Age Groups}
\usage{
derive_var_agegr_fda(dataset, age_var, age_unit = NULL, new_var)

derive_var_agegr_ema(dataset, age_var, age_unit = NULL, new_var)
}
\arguments{
\item{dataset}{Input dataset.}

\item{age_var}{AGE variable.}

\item{age_unit}{AGE unit variable.

The AGE unit variable is used to convert AGE to 'years' so that grouping can occur.
This is only used when the age_var variable does not have a corresponding unit in the dataset.

Default: NULL

Permitted Values: 'years', 'months', 'weeks', 'days', 'hours', 'minutes', 'seconds'}

\item{new_var}{New variable to be created.}
}
\value{
\code{dataset} with new column \code{new_var} of class factor.
}
\description{
Functions for deriving standardized age groups.
}
\details{
\code{derive_var_agegr_fda()} derives age groups according to FDA guidance. \code{age_var}
will be split in categories: <18, 18-64, >=65.

\code{derive_var_agegr_ema()} derives age groups according to EMA guidance.
\code{age_var} will be split into categories: 0-27 days (Newborns), 28 days to
23 months (Infants and Toddlers), 2-11 (Children), 12-17 (Adolescents), 18-64,
65-84, >=85.
}
\examples{
library(dplyr, warn.conflicts = FALSE)
library(admiral.test)
data(dm)

dm \%>\%
  derive_var_agegr_fda(age_var = AGE, new_var = AGEGR1) \%>\%
  select(SUBJID, AGE, AGEGR1)

data <- tibble::tribble(
  ~BRTHDT, ~RANDDT,
  lubridate::ymd("1984-09-06"), lubridate::ymd("2020-02-24")
  )

data \%>\%
  derive_vars_aage(unit = "months") \%>\%
  derive_var_agegr_fda(AAGE, age_unit = NULL, AGEGR1)

data.frame(AGE = 1:100) \%>\%
  derive_var_agegr_fda(age_var = AGE, age_unit = "years", new_var = AGEGR1)

library(dplyr, warn.conflicts = FALSE)
library(admiral.test)
data(dm)

dm \%>\%
  derive_var_agegr_ema(age_var = AGE, new_var = AGEGR1) \%>\%
  select(SUBJID, AGE, AGEGR1)

data.frame(AGE = 1:100) \%>\%
  derive_var_agegr_ema(age_var = AGE, age_unit = "years", new_var = AGEGR1)

data.frame(AGE = 1:20) \%>\%
  derive_var_agegr_ema(age_var = AGE, age_unit = "years", new_var = AGEGR1)
}
\author{
Ondrej Slama
}
