% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01genericSupport.r
\name{amigaIntToRaw}
\alias{amigaIntToRaw}
\title{Convert Amiga integers into raw values}
\usage{
amigaIntToRaw(x, bits = 8, signed = F)
}
\arguments{
\item{x}{A vector of class \code{numeric} which needs to be converted into raw values.}

\item{bits}{Number of bits that represents the integer value. Should be 8 or a
positive multitude of 8.}

\item{signed}{A \code{logical} value indicating whether the numeric values
is signed (\code{TRUE}, default) or not (\code{FALSE}).}
}
\value{
Returns (a \code{vector} of) \code{raw} data, representing
the integer value(s) conform Amiga specifications.
}
\description{
Convert 8, 16, or 32-bit signed or unsigned
integer values into raw data, conform Amiga specifications.
}
\details{
The Commodore Amiga has specified the following data formats
to represent integer data: BYTE (signed 8-bit integer), UBYTE
(unsigned 8-bit integer), WORD (signed 16-bit integer), UWORD
(unsigned 16-bit integer), LONG (signed 32-bit integer), ULONG,
(unsigned 32-bit integer). This function converts 
such integers into raw data.
}
\examples{
## some unsigned 8-bit integers:
ubyte <- sample.int(255, 100, TRUE)

## The same values as raw data:
amigaIntToRaw(ubyte)

## some signed 8-bit integers:
byte <- sample.int(255, 100, TRUE) - 128

## The same values as raw data:
amigaIntToRaw(byte, signed = TRUE)

## some signed 16-bit integers:
word <- sample.int(2^16, 100, TRUE) - 2^15

## The same values as raw data:
amigaIntToRaw(word, 16, TRUE)

## note that 16-bit integers require
## twice as many raw values:
length(amigaIntToRaw(word, 16, TRUE))
length(amigaIntToRaw(byte, 8, TRUE))
}
\seealso{
Other raw.operations: 
\code{\link{amigaDateToRaw}()},
\code{\link{displayRawData}()},
\code{\link{rawToAmigaDate}()},
\code{\link{rawToAmigaInt}()},
\code{\link{rawToBitmap}()}
}
\author{
Pepijn de Vries
}
\concept{raw.operations}
