% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04fileOperations.r
\docType{methods}
\name{dir.create.adf}
\alias{dir.create.adf}
\alias{dir.create.adf,amigaDisk,character,missing,missing-method}
\alias{dir.create.adf}
\alias{dir.create.adf,amigaDisk,character,POSIXt,missing-method}
\alias{dir.create.adf}
\alias{dir.create.adf,amigaDisk,character,POSIXt,character-method}
\title{Create a directory on an amigaDisk object}
\usage{
\S4method{dir.create.adf}{amigaDisk,character,missing,missing}(x, path, date,
  comment)

\S4method{dir.create.adf}{amigaDisk,character,POSIXt,missing}(x, path, date,
  comment)

\S4method{dir.create.adf}{amigaDisk,character,POSIXt,character}(x, path, date,
  comment)
}
\arguments{
\item{x}{An \code{\link{amigaDisk}} on which the directory should be created.}

\item{path}{Specify the directory that should be created on \code{x}.
You can specify the full path on the virtual disk conform Amiga DOS syntax
(see \code{\link{current.adf.dir}} details). When no full path is specified
the new directory will be created in the current directory. Note that
wild cards are not allowed.}

\item{date}{A \code{\link{POSIXt}} object that will be used as the
directory modification date. When missing the system time will used.}

\item{comment}{An optional \code{character} string that will be included
in the directory header as a comment. Should not be longer than 79 characters.}
}
\value{
Returns an \code{\link{amigaDisk}} object on which the
directory is created.
}
\description{
Create a directory on a virtual amiga floppy disk represented by
an \code{\link{amigaDisk}} object.
}
\details{
Create a directory on a virtual amiga floppy disk represented by
an \code{\link{amigaDisk}} object. Make sure that the virtual disk
is DOS formatted.
}
\examples{
\dontrun{
## create a blank DOS disk:
blank.disk <- blank.amigaDOSDisk("blank", "DD", "FFS", TRUE, FALSE, FALSE)

## creating a new directory on the blank disk is easy:
blank.disk <- dir.create.adf(blank.disk, "new_dir")

## in the line above, the directory is placed in the
## current directory (the root in this case). Directories
## can also be created by specifying the full path:

blank.disk <- dir.create.adf(blank.disk, "DF0:new_dir/sub_dir")

## check whether we succeeded:
list.adf.files(blank.disk)

## we can even make it the current dir:
current.adf.dir(blank.disk) <- "DF0:new_dir/sub_dir"
}
}
\author{
Pepijn de Vries
}
