% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm.R
\name{glm.gaussian}
\alias{glm.gaussian}
\title{Creates a Gaussian GLM family object.}
\usage{
glm.gaussian(y, weights = NULL, opt = TRUE)
}
\arguments{
\item{y}{Response vector.}

\item{weights}{Observation weight vector, with default \code{NULL}.}

\item{opt}{If \code{TRUE} (default), an optimized routine is run.}
}
\value{
Gaussian GLM
}
\description{
A GLM family object specifies the type of model fit, provides the appropriate response object and makes sure it is represented in the right form for the model family, and allows for optional parameters such as a weight vector.
}
\examples{
n <- 100
y <- rnorm(n)
obj <- glm.gaussian(y)
}
\seealso{
\code{glm.gaussian}, \code{glm.binomial}, \code{glm.poisson},  \code{glm.multinomial}, \code{glm.multigaussian}, \code{glm.cox}.
}
\author{
James Yang, Trevor Hastie, and  Balasubramanian Narasimhan \cr Maintainer: Trevor Hastie \href{mailto:hastie@stanford.edu}{hastie@stanford.edu}
}
