% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.R
\name{matrix.snp_unphased}
\alias{matrix.snp_unphased}
\title{Creates a SNP unphased matrix.}
\usage{
matrix.snp_unphased(io, n_threads = 1)
}
\arguments{
\item{io}{IO handler.}

\item{n_threads}{Number of threads.}
}
\value{
SNP unphased matrix.
}
\description{
Creates a SNP unphased matrix.
}
\examples{
n <- 123
s <- 423
filename <- paste(tempdir(), "snp_unphased_dummy.snpdat", sep="/")
handle <- io.snp_unphased(filename)
mat <- matrix(
    as.integer(sample.int(
        3, n * s, 
        replace=TRUE, 
        prob=c(0.7, 0.2, 0.1)
    ) - 1),
    n, s
)
impute <- double(s)
handle$write(mat, "mean", impute, 1)
out <- matrix.snp_unphased(handle)
file.remove(filename)
}
