% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error.R
\name{adbc_error_from_array_stream}
\alias{adbc_error_from_array_stream}
\title{Get extended error information from an array stream}
\usage{
adbc_error_from_array_stream(stream)
}
\arguments{
\item{stream}{A \link[nanoarrow:as_nanoarrow_array_stream]{nanoarrow_array_stream}}
}
\value{
\code{NULL} if stream was not created by a driver that supports
extended error information or a list whose first element is the
status code and second element is the \code{adbc_error} object. The
\code{acbc_error} must not be accessed if \code{stream} is explicitly released.
}
\description{
Get extended error information from an array stream
}
\examples{
db <- adbc_database_init(adbc_driver_monkey())
con <- adbc_connection_init(db)
stmt <- adbc_statement_init(con, mtcars)
stream <- nanoarrow::nanoarrow_allocate_array_stream()
adbc_statement_execute_query(stmt, stream)
adbc_error_from_array_stream(stream)

}
