% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{read_adbc}
\alias{read_adbc}
\alias{execute_adbc}
\alias{write_adbc}
\title{Read, write, and execute on ADBC connections}
\usage{
read_adbc(db_or_con, query, ..., bind = NULL)

execute_adbc(db_or_con, query, ..., bind = NULL)

write_adbc(
  tbl,
  db_or_con,
  target_table,
  ...,
  mode = c("default", "create", "append"),
  temporary = FALSE
)
}
\arguments{
\item{db_or_con}{An adbc_database or adbc_connection. If a database, a
connection will be opened. For \code{read_adbc()}, this connection will
be closed when the resulting stream has been released.}

\item{query}{An SQL query}

\item{...}{Passed to S3 methods.}

\item{bind}{A data.frame, nanoarrow_array, or nanoarrow_array_stream of
bind parameters or NULL to skip the bind/prepare step.}

\item{tbl}{A data.frame, \link[nanoarrow:as_nanoarrow_array]{nanoarrow_array},
or  \link[nanoarrow:as_nanoarrow_array_stream]{nanoarrow_array_stream}.}

\item{target_table}{A target table name to which \code{tbl} should be written.}

\item{mode}{One of "create", "append", or "default" (error if the schema
is not compatible or append otherwise).}

\item{temporary}{Use TRUE to create a table as a temporary table.}
}
\value{
\itemize{
\item \code{read_adbc()}: A \link[=as_nanoarrow_array_stream]{nanoarrow_array_stream}
\item \code{execute_adbc()}: \code{db_or_con}, invisibly.
\item \code{write_adbc()}: \code{tbl}, invisibly.
}
}
\description{
These are convenience methods useful for testing connections. Note that
S3 dispatch is always on \code{db_or_con} (i.e., drivers may provide their own
implementations).
}
\examples{
# On a database, connections are opened and closed
db <- adbc_database_init(adbc_driver_log())
try(read_adbc(db, "some sql"))
try(execute_adbc(db, "some sql"))
try(write_adbc(mtcars, db, "some_table"))

# Also works on a connection
con <- adbc_connection_init(db)
try(read_adbc(con, "some sql"))
try(execute_adbc(con, "some sql"))
try(write_adbc(mtcars, con, "some_table"))

}
