% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{ggTukey.data.frame}
\alias{ggTukey.data.frame}
\title{ggTukey for data.frame}
\usage{
\method{ggTukey}{data.frame}(obj, formula, which = 1, splt = NULL, ...)
}
\arguments{
\item{obj}{a data frame}

\item{formula}{a formula to be used in the aov call}

\item{which}{the index of the comparison. Used when the formula in the
undelying aov call has more than one term.}

\item{splt}{a formula to split the data frame}

\item{...}{further parameters passed to \code{TukeyHSD}}
}
\value{
a GGPlot2 object
}
\description{
ggTukey for data.frame
}
\examples{
library(tidyverse)
examples_url("battery.dat") \%>\%
  read_table() \%>\%
  mutate(across(c(Temperature, Material), factor)) \%>\%
  ggTukey(Response~Material, splt=~Temperature)
}
