% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_history.R
\name{plot_history}
\alias{plot_history}
\alias{plot_history.trial_result}
\alias{plot_history.trial_results}
\title{Plot trial metric history}
\usage{
plot_history(object, x_value = "look", y_value = "prob", line = NULL, ...)

\method{plot_history}{trial_result}(object, x_value = "look", y_value = "prob", line = NULL, ...)

\method{plot_history}{trial_results}(
  object,
  x_value = "look",
  y_value = "prob",
  line = NULL,
  ribbon = list(width = 0.5, alpha = 0.2),
  ...
)
}
\arguments{
\item{object}{\code{trial_results} object, output from the \code{\link[=run_trials]{run_trials()}}
function.}

\item{x_value}{single character string, determining whether the number of
adaptive analysis looks (\code{"look"}, default) or the total cumulated number of
patients allocated (\code{"total n"}) are plotted on the x-axis.}

\item{y_value}{single character string, determining which values are plotted
on the y-axis. The following options are available: allocation
probabilities (\code{"prob"}, default), the total number of patients allocated
to each arm (\code{"n"}), the percentage of patients allocated to each arm of
the total number of patients randomised (\code{"pct"}), the sum of all outcomes
in each arm (\code{"sum ys"}), the ratio of outcomes (\code{"ratio ys"}, the sum of
outcomes in each arm divided by the number of patients allocated to that
arm).}

\item{line}{list styling the lines as per \pkg{ggplot2} conventions (e.g.,
\code{linetype}, \code{size}).}

\item{...}{additional arguments, not used.}

\item{ribbon}{list, as \code{line} but only appropriate for \code{trial_results}
objects (i.e., when multiple simulations are run). Also allows to specify
the \code{width} of the interval: must be between 0 and 1, with \code{0.5} (default)
showing the inter-quartile ranges.}
}
\value{
A \code{ggplot2} plot object.
}
\description{
Plots the history of relevant metrics over the progress of single or multiple
simulations. Simulated trials \strong{only} contribute until the time they are
stopped, i.e., if some trials are stopped earlier than others, they will not
contribute to the summary statistics at later adaptive looks. Data from
individual arms in a trial contribute until the complete trial is stopped.\cr
These history plots require non-sparse results (\code{sparse} set to
\code{FALSE}; see \code{\link[=run_trial]{run_trial()}} and \code{\link[=run_trials]{run_trials()}}) and the \code{ggplot2} package
installed.
}
\examples{
#### Only run examples if ggplot2 is installed ####
if (requireNamespace("ggplot2", quietly = TRUE)){

  # Setup a trial specification
  binom_trial <- setup_trial_binom(arms = c("A", "B", "C", "D"),
                                   control = "A",
                                   true_ys = c(0.20, 0.18, 0.22, 0.24),
                                   data_looks = 1:20 * 100)



  # Run a single simulation with a fixed random seed
  res <- run_trial(binom_trial, seed = 12345)

  # Plot total allocations to each arm according to overall total allocations
  plot_history(res, x_value = "total n", y_value = "n")



  # Run multiple simulation with a fixed random base seed
  # Notice that sparse = FALSE is required
  res_mult <- run_trials(binom_trial, n_rep = 15, base_seed = 12345, sparse = FALSE)

  # Plot allocation probabilities at each look
  plot_history(res_mult, x_value = "look", y_value = "prob")

  # Other y_value options are available but not shown in these examples

  # Do not return/print last plot in documentation
  invisible(NULL)
}

}
\seealso{
\code{\link[=plot_status]{plot_status()}}.
}
