% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_alphas_rss_multiv.R
\name{do_alphas_rss_multiv}
\alias{do_alphas_rss_multiv}
\title{Alphas and RSS of every set of multivariate archetypoids}
\usage{
do_alphas_rss_multiv(data, subset, huge, k_subset, rand_obs, alphas_subset, 
                  type_alg = "ada", PM, prob, nbasis, nvars)
}
\arguments{
\item{data}{Data matrix with all the observations.}

\item{subset}{Data matrix with a sample of the \code{data} observations.}

\item{huge}{Penalization added to solve the convex least squares problems.}

\item{k_subset}{Archetypoids obtained from \code{subset}.}

\item{rand_obs}{Sample observations that form \code{subset}.}

\item{alphas_subset}{Alpha coefficients related to \code{k_subset}.}

\item{type_alg}{String. Options are 'ada' for the non-robust multivariate adalara 
algorithm, 'ada_rob' for the robust multivariate adalara algorithm, 'fada' for 
the non-robust fda fadalara algorithm and 'fada_rob' for the robust fda
fadalara algorithm.}

\item{PM}{Penalty matrix obtained with \code{\link[fda]{eval.penalty}}. Needed when
\code{type_alg = 'fada'} or \code{type_alg = 'fada_rob'}.}

\item{prob}{Probability with values in [0,1]. Needed when
\code{type_alg = 'ada_rob'} or \code{type_alg = 'fada_rob'}.}

\item{nbasis}{Number of basis.}

\item{nvars}{Number of variables.}
}
\value{
A list with the following elements:
\itemize{
\item rss Real number of the residual sum of squares.
\item resid_rss Matrix with the residuals.
\item alphas Matrix with the alpha values.
}
}
\description{
In the ADALARA algorithm, every time that a set of archetypoids is computed using
a sample of the data, the alpha coefficients and the associated residual sum of 
squares (RSS) for the entire data set must be computed.
}
\examples{
\dontrun{
library(fda)
?growth
str(growth)
hgtm <- growth$hgtm
hgtf <- growth$hgtf[,1:39]

# Create array:
nvars <- 2
data.array <- array(0, dim = c(dim(hgtm), nvars))
data.array[,,1] <- as.matrix(hgtm)
data.array[,,2] <- as.matrix(hgtf)
rownames(data.array) <- 1:nrow(hgtm)
colnames(data.array) <- colnames(hgtm)
str(data.array)

# Create basis:
nbasis <- 10
basis_fd <- create.bspline.basis(c(1,nrow(hgtm)), nbasis)
PM <- eval.penalty(basis_fd)
# Make fd object:
temp_points <- 1:nrow(hgtm)
temp_fd <- Data2fd(argvals = temp_points, y = data.array, basisobj = basis_fd)

X <- array(0, dim = c(dim(t(temp_fd$coefs[,,1])), nvars))
X[,,1] <- t(temp_fd$coef[,,1]) 
X[,,2] <- t(temp_fd$coef[,,2])

# Standardize the variables:
Xs <- X
Xs[,,1] <- scale(X[,,1])
Xs[,,2] <- scale(X[,,2])
# We have to give names to the dimensions to know the 
# observations that were identified as archetypoids.
dimnames(Xs) <- list(paste("Obs", 1:dim(hgtm)[2], sep = ""), 
                     1:nbasis,
                     c("boys", "girls"))

n <- dim(Xs)[1] 
# Number of archetypoids:
k <- 3 
numRep <- 20
huge <- 200

# Size of the random sample of observations:
m <- 15
# Number of samples:
N <- floor(1 + (n - m)/(m - k))
N
prob <- 0.75
data_alg <- Xs

nbasis <- dim(data_alg)[2] # number of basis.
nvars <- dim(data_alg)[3] # number of variables.
n <- nrow(data_alg)

set.seed(1) 
rand_obs_si <- sample(1:n, size = m)  
si <- apply(data_alg, 2:3, function(x) x[rand_obs_si])  

fada_si <- do_fada_multiv_robust(si, k, numRep, huge, 0.8, FALSE, PM)

k_si <- fada_si$cases
alphas_si <- fada_si$alphas
colnames(alphas_si) <- rownames(si)

rss_si <- do_alphas_rss_multiv(data_alg, si, huge, k_si, rand_obs_si, alphas_si, 
                               "fada_rob", PM, 0.8, nbasis, nvars)
str(rss_si)                                
}
                                 
}
\seealso{
\code{\link{archetypoids_norm_frob}}
}
\author{
Guillermo Vinue
}
