% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ig_results.R
\name{get_ig_results}
\alias{get_ig_results}
\title{Get intensity gradient values and graphics}
\usage{
get_ig_results(
  data,
  col_axis = "vm",
  col_time = "time",
  valid_wear_time_start = "00:00:00",
  valid_wear_time_end = "23:59:59",
  start_first_bin = 0,
  start_last_bin = 10000,
  bin_width = 500,
  cor_factor = 1
)
}
\arguments{
\item{data}{A dataframe obtained using the \code{\link{prepare_dataset}}, \code{\link{mark_wear_time}},
and then the \code{\link{mark_intensity}} functions. Data should be grouped by day and then nested.}

\item{col_axis}{A character value to indicate the name of the variable to be used to compute total time per bin of intensity.}

\item{col_time}{A character value to indicate the name of the variable to be used to determine the epoch length of the dataset.}

\item{valid_wear_time_start}{A character value with the HH:MM:SS format to set the start of the daily period that will be considered for computing metrics.}

\item{valid_wear_time_end}{A character value with the HH:MM:SS format to set the end of the daily period that will be considered for computing metrics.}

\item{start_first_bin}{A numeric value to set the lower bound of the first bin of the intensity band (in counts/epoch duration).}

\item{start_last_bin}{A numeric value to set the lower bound of the last bin of the intensity band (in counts/epoch duration).}

\item{bin_width}{A numeric value to set the width of the bins of the intensity band (in counts/epoch duration).}

\item{cor_factor}{A numeric value resulting from the ratio between 60s and the epoch length of the analysed dataset. This is used to convert
the number of rows into minutes when getting the results.}
}
\value{
A list of objects.
}
\description{
The values and graphics are respectively computed and created from the daily periods set for analysis and are based on detected wear time.
}
