% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{timesToCircular}
\alias{timesToCircular}
\title{Convert a data frame with timestamps into a list of circular objects}
\usage{
timesToCircular(x, by.group = FALSE)
}
\arguments{
\item{x}{A data frame where the first column is an identifier, the second column
is a grouping structure, and columns three and onwards are timestamps at different
locations. Can be generated automatically by \code{\link{getTimes}}.}

\item{by.group}{Logical: Should the times at each location be divided by the group column (second column of x)?}
}
\value{
A list of circular objects for each data column and, optionally, for each group.
}
\description{
Convert a data frame with timestamps into a list of circular objects
}
\examples{
# create dummy input data frame.
# Note: the names of the columns are irrelevant.
x <- data.frame(ID = c(1:5), 
 Group = c("A", "A", "B", "B", "B"), 
 A1 = as.POSIXct(
   c("2019-01-03 11:21:12",
     "2019-01-04 12:22:21",
     "2019-01-05 13:31:34",
     "2019-01-06 14:32:43",
     "2019-01-07 15:23:52")),
 A2 = as.POSIXct(
   c("2019-01-08 16:51:55",
     "2019-01-09 17:42:42",
     "2019-01-10 18:33:33",
     "2019-01-11 19:24:32",
     "2019-01-12 20:15:22")),
 stringsAsFactors = TRUE)

# run timesToCircular
timesToCircular(x)

# optionally, split results by group:
timesToCircular(x, by.group = TRUE)

}
