% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_cuts.R
\name{search_cuts}
\alias{search_cuts}
\title{Create print transcripts, media cutlists and srt subtitles for all search results}
\usage{
search_cuts(
  x,
  s,
  cutSpanBeforesec = NULL,
  cutSpanAftersec = NULL,
  l = NULL,
  outputFolder = NULL
)
}
\arguments{
\item{x}{Corpus object.}

\item{s}{Search object.}

\item{cutSpanBeforesec}{Double; Start the cut some seconds before the hit to include some context; the default NULL will take the value as set in @cuts.span.beforesec of the search object.}

\item{cutSpanAftersec}{Double; End the cut some seconds before the hit to include some context; the default NULL will take the value as set in @cuts.span.beforesec of the search object.}

\item{l}{Layout object.}

\item{outputFolder}{Character string; if parameter is not set, the print transcripts will only be inserted in \code{s@results}; if the path to a existing folder is given transcripts will be saved in '.txt' format.}
}
\value{
Search object;
}
\description{
This function will call the following functions:
\itemize{
\item \code{act_cuts_printtranscript} to create print transcripts,
\item \code{act::cuts_media} to create FFmpeg cutlist to make media snippets,
\item \code{act::search_cuts_srt()} to create .srt subtitles,
for all  search results.
}

For a detailed description including examples please refer to the documentation of the indidival functions.
They also offer some more parameters than this functions. If you want to use those, call the functions individually.
}
\examples{
library(act)

# IMPORTANT: In the example corpus all transcripts are assigned media links.
# The actual media files are, however, not included in when installing the package 
# due to size limitations of CRAN.
# But you may download the media files separately.
# Please see the section 'examplecorpus' for instructions. 
# --> You will need the media files to execute the following example code.

\dontrun{
	# Search
	mysearch <- act::search_new(examplecorpus, pattern="yo")
	
	# Create print transcripts, media cutlists and .srt subtitles 
	# for all search results
	test <- act::search_cuts(x=examplecorpus, s=mysearch)
	
	# Display all print transcripts on screen from @cuts.printtranscripts
	cat(test@cuts.printtranscripts)
	
	# Display cutlist on screen from @cuts.cutlist.mac
	cat(test@cuts.cutlist.mac)
	
	# Display .srt subtitles
	cat(test@results[, mysearch@cuts.column.srt])
}

}
