# This provided discrete (permutation) perturbations
# it is essentially a wrapper for PTBfactor

PTBdiscrete<-function(x,r=NULL,q=.99) {
  if (is.null(r)) {
     r=reclass.mat.default(x,q)
  }

  if (is.integer(x)) {
     return(as.integer(as.character(PTBfactor(as.factor(x),r))))
  } else if (is.numeric(x)) {
     return(as.numeric(as.character(PTBfactor(as.factor(x),r))))
  } else if (is.character(x)) {
    return(PTBcharacter(x,r));
  } else if (is.logical(x)) {
    return(PTBlogical(x,r))
  } else if(is.factor(x)) {
    return(PTBfactor(x,r))
  } else {
    warning("coercing x to a factor")
    return(PTBfactor(as.factor(x),r))
  }
}

# default reclass matrix
reclass.mat.default<-function(x,q=.99) {
     if (is.logical(x)) {
        r=reclass.mat.random(2,q)
     } else if(is.numeric(x)) {
       r=reclass.mat.diag(length(levels(as.factor(x))),q)
     } else if(is.ordered(x)) {
       reclass.mat.diag(length(levels(vec)),q)
     } else {
        r=reclass.mat.random(length(levels(as.factor(x))),q)
     }
     return(r)
}

# Heuristic to supply  a default perturbation function given a vector of data

PTBdefaultfn<-function(vec,q=.99) {

    if (is.numeric(vec) && !is.discrete(vec)) {
       return(function(x){PTBus(x,1-q)})
    } else {
       tmpr=reclass.mat.default(vec,q)
       return(function(x){PTBdiscrete(x,tmpr)})
    }
}

# Heuristic to supply  a default perturbation function given a vector of data

PTBdefault<-function(vec,q=.99) {

    if (is.numeric(vec) && !is.discrete(vec)) {
       return(PTBus(vec,1-q))
    } else {
       tmpr=reclass.mat.default(vec,q)
       return(PTBdiscrete(vec,tmpr))
    }
}

# is.discrete(x)
#
# Attempts to evaluate whether vector contains discrete values

is.discrete<-function(x) {
	if (is.data.frame(x) || is.list(x)) {
		return(sapply(x,is.discrete))
	}
	x=as.vector(x);
	if (is.integer(x)) {
		return (TRUE);
	}  else if (is.factor(x)) {
		return (TRUE);
  } else if (is.logical(x)) {
    return (TRUE);
  } else if (is.character(x)) {
    return(TRUE);
	} else  if (sum(as.integer(x)!=x)==0) {
		return (TRUE);
	}
	return (FALSE);
}

# This perturbs a factor, its the workhorse method
# It uses a classification matrix generated by reclass.mat.* or by reclassify()
# in the perturb package

PTBfactor<-function(x,r) {
  x=as.factor(x)

  if (!inherits(r,"reclassify") && !is.matrix(r)) {
		stop("r must be a reclassification object, or cumulative probability matrix")
	}
	if (inherits(r,"reclassify")) {
		cumprob = r$cum.reclass.prob
	} else {
		cumprob = r
	}

	ret= sapply( as.data.frame(t(cumprob[x,]>runif(length(x)))),
				function(tmp){min(which(tmp))}
		)

  ret=factor(ret,labels=levels(x),levels=1:length(levels(x)))
	return(ret)
}

# This perturbs a logical variable using a classification matrix

PTBlogical<-function(x,r) {

    as.logical(PTBdiscrete(as.factor(x),r))
}

# This perturbs a character variable using a classification matrix

PTBcharacter<-function(x,r) {
   as.character(PTBdiscrete(as.factor(x),r))
}




# This returns a cumulative probability matrix useful for reclassifying
# discrete variables with PTBfactor
#
# n is the number of factor levels
# q is the probability of remaining at the same level
#
# The transition probability of changing from i->j is 0 if |i-j|>1


reclass.mat.diag<-function(n,q) {
  p=1-q
  # mostly a diagnal with 1's in the upper
	d = diag(1-p/2,nrow=n,ncol=n)
	d[upper.tri(d)]=1

  # fixup corner cases
	d[n,n-1]=p
	d[1,1]=1-p
	d[1,2]=1
	d[n,n]=1

	for (i in 2:n-1) {
		d[i,i-1]=(p/2)
	}
	return(d)
}


# This returns a cumulative probability matrix useful for reclassifying
# discrete variables with PTBfactor
#
# n is the number of factor levels
# q is the probability of remaining at the same level
#
# The transition probability of changing from i->j is uniform

reclass.mat.random<-function(n,q) {
  p=1-q
  d = matrix(data=0, nrow=n, ncol=n)
	d[upper.tri(d)]=1
	d[n,n]=1

	inc = p/(n-1)
  for (i in 1:n) {
     for (j in 1:n-1) {
         if (j<i) {
            d[i,j] = j*inc
         } else if (j==i) {
            d[i,j] = (1-p)+(j-1)*inc
         } else {
            d[i,j] = 1 - ((n-j)*inc)
         }
      }
  }
	return(d)
}
