% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.matrix.R
\name{generate.matrix}
\alias{generate.matrix}
\title{Generate matrix composed of a sparse matrix and low-rank matrix}
\usage{
generate.matrix(
  n,
  p,
  rank = NULL,
  support.size = NULL,
  beta = NULL,
  snr = Inf,
  sigma = NULL,
  seed = 1
)
}
\arguments{
\item{n}{The number of observations.}

\item{p}{The number of predictors of interest.}

\item{rank}{The rank of low-rank matrix.}

\item{support.size}{The number of nonzero coefficients in the underlying regression
model. Can be omitted if \code{beta} is supplied.}

\item{beta}{The coefficient values in the underlying regression model.
If it is supplied, \code{support.size} would be omitted.}

\item{snr}{A positive value controlling the signal-to-noise ratio (SNR).
A larger SNR implies the identification of sparse matrix is much easier.
Default \code{snr = Inf} enforces no noise exists.}

\item{sigma}{A numerical value supplied the variance of the gaussian noise. 
Default \code{sigma = NULL} implies it is determined by \code{snr}.}

\item{seed}{random seed. Default: \code{seed = 1}.}
}
\value{
A \code{list} object comprising:
\item{x}{An \eqn{n}-by-\eqn{p} matrix.}
\item{L}{The latent low rank matrix.}
\item{S}{The latent sparse matrix.}
}
\description{
Generate simulated matrix that is the superposition of
a low-rank component and a sparse component.
}
\details{
The low rank matrix \eqn{L} is generated by \eqn{L = UV}, where
\eqn{U} is an \eqn{n}-by-\eqn{rank} matrix and
\eqn{V} is a \eqn{rank}-by-\eqn{p} matrix.
Each element in \eqn{U} (or \eqn{V}) are i.i.d. drawn from \eqn{N(0, 1/n)}.

The sparse matrix \eqn{S} is an \eqn{n}-by-\eqn{rank} matrix.
It is generated by choosing a support set of size
\code{support.size} uniformly at random.
The non-zero entries in \eqn{S} are independent Bernoulli (-1, +1) entries.

The noise matrix \eqn{N} is an \eqn{n}-by-\eqn{rank} matrix,
the elements in \eqn{N} are i.i.d. gaussian random variable
with standard deviation \eqn{\sigma}.

The SNR is defined as
as the variance of vectorized matrix \eqn{L + S} divided
by \eqn{\sigma^2}.

The matrix \eqn{x} is the superposition of \eqn{L}, \eqn{S}, \eqn{N}:
\deqn{x = L + S + N.}
}
\examples{
# Generate simulated data
n <- 30
p <- 20
dataset <- generate.matrix(n, p)
\donttest{
stats::heatmap(as.matrix(dataset[["S"]]),
  Rowv = NA,
  Colv = NA,
  scale = "none",
  col = grDevices::cm.colors(256),
  frame.plot = TRUE,
  margins = c(2.4, 2.4)
)
}
}
\author{
Jin Zhu
}
