% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MTaSPUsSet.R
\name{MTaSPUsSet}
\alias{MTaSPUsSet}
\title{gene-Multitrait Sum of Powered Score (MTSPUsSet) tests and adaptive MTSPUsSet (MTaSPUsSet) test for multi trait - SNP set association with GWAS summary statistics.}
\usage{
MTaSPUsSet(
  Zs,
  corSNP,
  corPhe,
  pow = c(1, 2, 4, 8),
  pow2 = c(1, 2, 4, 8),
  n.perm = 5000,
  Ps = FALSE,
  prune = TRUE
)
}
\arguments{
\item{Zs}{Z-score matrix. row represent SNPs and column represent traits. It could be P-values if the Ps option is TRUE.}

\item{corSNP}{Correlation matirx of the SNPs to be tested; estimated from a
reference panel (based on the same set of the reference alleles as
used in calculating Z-scores).}

\item{corPhe}{Correlation matirx of phenotypes to be tested; Estimated from Z-scores.}

\item{pow}{SNP specific power(gamma values) used in MTSPUsSet test.}

\item{pow2}{GENE specific power(gamma values) used in MTSPUsSet test.}

\item{n.perm}{number of permutations or bootstraps.}

\item{Ps}{TRUE if input is p-value, FALSE if input is Z-scores. The default is FALSE.}

\item{prune}{if it is TRUE, do pruing before the test using pruneSNP function.}
}
\value{
A vector object, MTSPUsSet test P values and MTaSPUsSet P value.
}
\description{
It gives p-values of the MTSPUsSet tests and MTaSPUsSet test with GWAS summary statistics.
}
\examples{

data(SAMD11)
attach(SAMD11)
## example analysis using MTaSPUsSet test.
(outFZ <- MTaSPUsSet(ZsF, corSNP=corSNPF, corPhe = corPheF,
      pow=c(1,2,4,8),  pow2 = c(1,2,4,8), n.perm=10, Ps=FALSE))

}
\references{
Il-Youp Kwak, Wei Pan (2017)
Gene- and pathway-based association tests for multiple
     traits with GWAS summary statistics, Bioinformatics, 33(1), 64-71.
}
\author{
Il-Youp Kwak and Wei Pan
}
