% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_phyllotaxis.R
\name{canvas_phyllotaxis}
\alias{canvas_phyllotaxis}
\title{Draw a Phyllotaxis}
\usage{
canvas_phyllotaxis(
  colors,
  background = "#fafafa",
  iterations = 10000,
  angle = 137.5,
  size = 0.01,
  alpha = 1,
  p = 0.5
)
}
\arguments{
\item{colors}{a string or character vector specifying the color(s) used for the artwork.}

\item{background}{a character specifying the color used for the background.}

\item{iterations}{the number of iterations of the algorithm.}

\item{angle}{the angle at which to place the artwork.}

\item{size}{the size of the lines.}

\item{alpha}{transparency of the points.}

\item{p}{probability of drawing a point on each iteration.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function draws a phyllotaxis which resembles the arrangement of leaves on a plant stem.
}
\examples{
\donttest{
set.seed(1)

# Simple example
canvas_phyllotaxis(colors = colorPalette("tuscany1"))
}

}
\references{
\url{https://en.wikipedia.org/wiki/Phyllotaxis}
}
\seealso{
\code{colorPalette}
}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
