% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_flow.R
\name{canvas_flow}
\alias{canvas_flow}
\title{Draw A Flow Field}
\usage{
canvas_flow(colors, background = "#fafafa", lines = 500, lwd = 0.05,
            iterations = 100, resolution = 100, angles = NULL)
}
\arguments{
\item{colors}{a string or character vector specifying the color(s) used for the artwork.}

\item{background}{a character specifying the color used for the background.}

\item{lines}{the number of lines to draw.}

\item{lwd}{expansion factor for the line width.}

\item{iterations}{the maximum number of iterations for each line.}

\item{resolution}{resolution of the artwork in pixels per row/column. Increasing the resolution increases the quality of the artwork but also increases the computation time exponentially.}

\item{angles}{optional, a matrix containing the angles of the flow field . If \code{NULL} (default), angles are set according to the predictions of a supervised learning algorithm.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function draws flow fields on a canvas.
}
\examples{
\donttest{
set.seed(1)

# Simple example
canvas_flow(colors = colorPalette("dark2"))

# Advanced example
angles <- matrix(rnorm(200 * 200), nrow = 200, ncol = 200)
canvas_flow(colors = colorPalette("tuscany1"), angles = angles)
}

}
\references{
\url{https://tylerxhobbs.com/essays/2020/flow-fields}
}
\seealso{
\code{colorPalette}
}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
