% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_polylines.R
\name{canvas_polylines}
\alias{canvas_polylines}
\title{Paint Random Polygons and Lines on a Canvas}
\usage{
canvas_polylines(colors, background = '#fafafa', ratio = 0.5, iterations = 1000, 
                 alpha = NULL, size = 0.1, width = 500, height = 500)
}
\arguments{
\item{colors}{a string or character vector specifying the color(s) used for the artwork.}

\item{background}{a character specifying the color used for the lines.}

\item{ratio}{a positive value specifying the width of the polygons. Larger ratios cause more overlap.}

\item{iterations}{a positive integer specifying the number of iterations of the algorithm.}

\item{alpha}{a value specifying the transparency of the polygons. If \code{NULL} (the default), added layers become increasingly more transparent.}

\item{size}{a positive value specifying the size of the borders.}

\item{width}{a positive integer specifying the width of the artwork in pixels.}

\item{height}{a positive integer specifying the height of the artwork in pixels.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function draws many points on the canvas and connects these points into a polygon. After repeating this for all the colors, the edges of all polygons are drawn on top of the artwork.
}
\examples{
\donttest{
set.seed(11)
palette <- colorPalette('random', n = 10)
canvas_polylines(colors = palette)
}

}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
