% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configuration.R
\docType{data}
\name{aPEAR.methods}
\alias{aPEAR.methods}
\title{Default method configuration for aPEAR}
\format{
An object of class \code{aPEAR.methods.config} of length 5.
}
\usage{
aPEAR.methods
}
\value{
an object of class aPEAR.methods.config
}
\description{
A list with parameters for customizing how the clusters within the enrichment data
are calculated.
}
\details{
similarity: method for calculating similarity matrix between the pathways. Available
methods: 'jaccard', 'cosine' and 'correlation'

cluster: method for detecting pathway clusters. Available methods: 'markov', 'hier'
and 'spectral'. Using 'spectral' method requires that you have the \code{Spectrum}
package installed

clusterName: method for selecting cluster names. Available methods: 'pagerank',
'hits', 'nes' and 'pval'. The 'pagerank' and 'hits' algorithms analyse the connectivity
within the cluster to detect the most important node. The 'nes' and 'pval' methods
use enrichment results to determine the most important node within the cluster: the 'nes'
method will choose the node with the maximum absolute enrichment score value and the
'pval' method will choose the node with the lowest p-value. When using the 'nes' and
'pval' methods, please specify which column in the data to use with the \code{clusterNameColumn}
parameter

clusterNameColumn: which column in the dataset should be used to select the cluster
title. Required when \code{clusterName = 'nes'} and \code{clusterName = 'pval'}

minClusterSize: minimum cluster size (default: 2). Clusters with less elements than
specified will be dropped
}
\examples{
# Display all default methods used by aPEAR
aPEAR.methods

# Update methods to use different similarity metric
settings <- aPEAR.methods
settings$similarity <- 'cosine'
settings

}
\keyword{datasets}
