% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg.r.squared.R
\name{reg.r.squared}
\alias{reg.r.squared}
\title{R-squared for lm.fit}
\usage{
reg.r.squared(SSR,SSTO)
}
\arguments{
\item{SSR}{:regression sum of squares or explained of squares}

\item{SSTO}{:total sum of squares}
}
\description{
Calculate R-squared for the outcome of lm.fit(). This function is built for reg.linreg for higher efficiency only.
It can't be used for calculating R-squared in general operation.
}
\examples{
X <- as.matrix(cbind(1,EuStockMarkets[,1:2])) # create the design matrix
Y <- as.data.frame(EuStockMarkets)$FTSE
fit <- lm.fit(x = X, y = Y)
me <- mean(Y)
SSR <- sum((fit$fitted.values - me)^2)
SSTO <- sum((Y - me)^2)
reg.r.squared(SSR,SSTO)
}
