% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_method_05_XMLgenerators.R
\docType{methods}
\name{XMLgenerators}
\alias{XMLgenerators}
\alias{XMLgenerators,-methods}
\alias{XMLgenerators,XiMpLe.validity-method}
\alias{XMLgenerators,XiMpLe.validity-method}
\title{Generate XML generator functions from XiMpLe.valisity object}
\usage{
XMLgenerators(validity, prefix = "XML", checkValidity = TRUE,
  indent.by = "\\t", roxygenDocs = FALSE, valParam = "validity",
  replaceChar = "_", dir = NULL, overwrite = FALSE, oneFile = NULL)

\S4method{XMLgenerators}{XiMpLe.validity}(validity, prefix = "XML",
  checkValidity = TRUE, indent.by = "\\t", roxygenDocs = FALSE,
  valParam = "validity", replaceChar = "_", dir = NULL,
  overwrite = FALSE, oneFile = NULL)
}
\arguments{
\item{validity}{An dobject of class \code{XiMpLe.validity}.}

\item{prefix}{A character string to be used as a prefix for the resulting function names.}

\item{checkValidity}{Logical, whether all functions should include a check for valid XML.}

\item{indent.by}{A charachter string defining how indentation should be done.}

\item{roxygenDocs}{Logical,
      whether a skeleton for roxygen2-ish documentation should be added.}

\item{valParam}{A charachter string,
      name of the additional parameter to use for validation if
\code{checkValidity=TRUE}.}

\item{replaceChar}{A (single) character to be used as an replacement for invalid characters for
\code{R} parameter names.}

\item{dir}{A charachter string, path to write files to. If \code{dir=NULL},
      no files are being
written,
      but the results returned in form of a character vector. If \code{dir} is set and the
directory does not yet exist, it will be created.}

\item{overwrite}{Logical,
      whether existing files should be replaced when \code{dir} is set.}

\item{oneFile}{A charachter string. If set,
      all functions are to be documented in one single *.Rd file,
named like the string.}
}
\value{
If \code{dir=NULL} a named vector of character strings. Otherwise one or more files are
   written do the location specified via \code{dir}.
}
\description{
Takes an object of class \code{\link[XiMpLe:XiMpLe.validity-class]{XiMpLe.validity}}
and turns it into a character vector of generator functions for each XML node that
was defined.
}
\details{
The resulting code follows these rules:
\itemize{
   \item{Each child node gets its own argument, except if there is only one valid child
     node. It will use the dots element instead then.}
   \item{Each attribute will also get its own argument.}
   \item{If \code{CheckValidity=TRUE},
      one extra argument named after the value of \code{valParam} will be added.}
   \item{All arguments are set to \code{NULL} by default.}
   \item{Only the main level of \code{"allAttrs"} will be taken into account,
      there's no recursion for this slot.}
}
}
\examples{
HTMLish <- XMLValidity(
   children=list(
     body=c("a", "p", "ol", "ul", "strong"),
     head=c("title"),
     html=c("head", "body"),
     li=c("a", "br", "strong"),
     ol=c("li"),
     p=c("a", "br", "ol", "ul", "strong"),
     ul=c("li")
   ),
   attrs=list(
     a=c("href", "name"),
     p=c("align")
   ),
   allChildren=c("!--"),
   allAttrs=c("id", "class"),
   empty=c("br")
)
XMLgenerators(HTMLish)
}
\seealso{
\code{\link[XiMpLe:XMLValidity]{XMLValidity}} and
   \code{\link[XiMpLe:XiMpLe.validity-class]{XiMpLe.validity}}
}
\keyword{methods}
