/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.poi.POIXMLDocument;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.POIXMLException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.util.Internal;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.util.PackageHelper;
import org.apache.poi.util.Units;
import org.apache.poi.xslf.XSLFSlideShow;
import org.apache.poi.xslf.usermodel.XSLFFactory;
import org.apache.poi.xslf.usermodel.XSLFPictureData;
import org.apache.poi.xslf.usermodel.XSLFRelation;
import org.apache.poi.xslf.usermodel.XSLFSlide;
import org.apache.poi.xslf.usermodel.XSLFSlideLayout;
import org.apache.poi.xslf.usermodel.XSLFSlideMaster;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.officeDocument.x2006.relationships.STRelationshipId;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPresentation;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlideIdList;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlideIdListEntry;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlideSize;
import org.openxmlformats.schemas.presentationml.x2006.main.PresentationDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLSlideShow
extends POIXMLDocument {
    private static POILogger _logger = POILogFactory.getLogger(XMLSlideShow.class);
    private CTPresentation _presentation;
    private List<XSLFSlide> _slides;
    private Map<String, XSLFSlideMaster> _masters;
    protected List<XSLFPictureData> _pictures;

    public XMLSlideShow() {
        this(XMLSlideShow.empty());
    }

    public XMLSlideShow(OPCPackage pkg) {
        super(pkg);
        try {
            if (this.getCorePart().getContentType().equals(XSLFRelation.THEME_MANAGER.getContentType())) {
                this.rebase(this.getPackage());
            }
            this.load(XSLFFactory.getInstance());
        }
        catch (Exception e) {
            throw new POIXMLException(e);
        }
    }

    public XMLSlideShow(InputStream is) throws IOException {
        this(PackageHelper.open(is));
    }

    static final OPCPackage empty() {
        InputStream is = XMLSlideShow.class.getResourceAsStream("empty.pptx");
        if (is == null) {
            throw new RuntimeException("Missing resource 'empty.pptx'");
        }
        try {
            return OPCPackage.open(is);
        }
        catch (Exception e) {
            throw new POIXMLException(e);
        }
    }

    @Deprecated
    public XSLFSlideShow _getXSLFSlideShow() throws OpenXML4JException, IOException, XmlException {
        return new XSLFSlideShow(this.getPackage());
    }

    @Override
    protected void onDocumentRead() throws IOException {
        try {
            PresentationDocument doc = PresentationDocument.Factory.parse((InputStream)this.getCorePart().getInputStream());
            this._presentation = doc.getPresentation();
            HashMap<String, XSLFSlide> shIdMap = new HashMap<String, XSLFSlide>();
            this._masters = new HashMap<String, XSLFSlideMaster>();
            for (POIXMLDocumentPart p : this.getRelations()) {
                if (p instanceof XSLFSlide) {
                    shIdMap.put(p.getPackageRelationship().getId(), (XSLFSlide)p);
                    continue;
                }
                if (!(p instanceof XSLFSlideMaster)) continue;
                XSLFSlideMaster master = (XSLFSlideMaster)p;
                this._masters.put(p.getPackageRelationship().getId(), master);
            }
            this._slides = new ArrayList<XSLFSlide>();
            if (this._presentation.isSetSldIdLst()) {
                List slideIds = this._presentation.getSldIdLst().getSldIdList();
                for (CTSlideIdListEntry slId : slideIds) {
                    XSLFSlide sh = (XSLFSlide)shIdMap.get(slId.getId2());
                    if (sh == null) {
                        _logger.log(POILogger.WARN, (Object)("Slide with r:id " + slId.getId() + " was defined, but didn't exist in package, skipping"));
                        continue;
                    }
                    this._slides.add(sh);
                }
            }
        }
        catch (XmlException e) {
            throw new POIXMLException(e);
        }
    }

    @Override
    protected void commit() throws IOException {
        XmlOptions xmlOptions = new XmlOptions(DEFAULT_XML_OPTIONS);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(STRelationshipId.type.getName().getNamespaceURI(), "r");
        xmlOptions.setSaveSuggestedPrefixes(map);
        PackagePart part = this.getPackagePart();
        OutputStream out = part.getOutputStream();
        this._presentation.save(out, xmlOptions);
        out.close();
    }

    @Override
    public List<PackagePart> getAllEmbedds() throws OpenXML4JException {
        return Collections.unmodifiableList(this.getPackage().getPartsByName(Pattern.compile("/ppt/embeddings/.*?")));
    }

    public List<XSLFPictureData> getAllPictures() {
        if (this._pictures == null) {
            List<PackagePart> mediaParts = this.getPackage().getPartsByName(Pattern.compile("/ppt/media/.*?"));
            this._pictures = new ArrayList<XSLFPictureData>(mediaParts.size());
            for (PackagePart part : mediaParts) {
                this._pictures.add(new XSLFPictureData(part, null));
            }
        }
        return Collections.unmodifiableList(this._pictures);
    }

    public XSLFSlide createSlide() {
        CTSlideIdListEntry slideId2;
        CTSlideIdList slideList;
        int slideNumber = 256;
        int cnt = 1;
        if (!this._presentation.isSetSldIdLst()) {
            slideList = this._presentation.addNewSldIdLst();
        } else {
            slideList = this._presentation.getSldIdLst();
            for (CTSlideIdListEntry slideId2 : slideList.getSldIdList()) {
                slideNumber = (int)Math.max(slideId2.getId() + 1L, (long)slideNumber);
                ++cnt;
            }
        }
        XSLFSlide slide = (XSLFSlide)this.createRelationship(XSLFRelation.SLIDE, XSLFFactory.getInstance(), cnt);
        slideId2 = slideList.addNewSldId();
        slideId2.setId((long)slideNumber);
        slideId2.setId2(slide.getPackageRelationship().getId());
        String masterId = this._presentation.getSldMasterIdLst().getSldMasterIdArray(0).getId2();
        XSLFSlideMaster master = this._masters.get(masterId);
        XSLFSlideLayout layout = master.getLayout("blank");
        if (layout == null) {
            throw new IllegalArgumentException("Blank layout was not found");
        }
        slide.addRelation(layout.getPackageRelationship().getId(), layout);
        PackagePartName ppName = layout.getPackagePart().getPartName();
        slide.getPackagePart().addRelationship(ppName, TargetMode.INTERNAL, layout.getPackageRelationship().getRelationshipType());
        this._slides.add(slide);
        return slide;
    }

    public XSLFSlideMaster[] getSlideMasters() {
        return this._masters.values().toArray(new XSLFSlideMaster[this._masters.size()]);
    }

    public XSLFSlide[] getSlides() {
        return this._slides.toArray(new XSLFSlide[this._slides.size()]);
    }

    public void setSlideOrder(XSLFSlide slide, int newIndex) {
        int oldIndex = this._slides.indexOf(slide);
        if (oldIndex == -1) {
            throw new IllegalArgumentException("Slide not found");
        }
        this._slides.add(newIndex, this._slides.remove(oldIndex));
        List slideIds = this._presentation.getSldIdLst().getSldIdList();
        CTSlideIdListEntry oldEntry = (CTSlideIdListEntry)slideIds.get(oldIndex);
        slideIds.add(newIndex, oldEntry);
        slideIds.remove(oldEntry);
    }

    public XSLFSlide removeSlide(int index) {
        XSLFSlide slide = this._slides.remove(index);
        this.removeRelation(slide);
        this._presentation.getSldIdLst().getSldIdList().remove(index);
        return slide;
    }

    public Dimension getPageSize() {
        CTSlideSize sz = this._presentation.getSldSz();
        int cx = sz.getCx();
        int cy = sz.getCy();
        return new Dimension((int)Units.toPoints(cx), (int)Units.toPoints(cy));
    }

    public void setPageSize(Dimension pgSize) {
        CTSlideSize sz = CTSlideSize.Factory.newInstance();
        sz.setCx(Units.toEMU(pgSize.getWidth()));
        sz.setCy(Units.toEMU(pgSize.getHeight()));
        this._presentation.setSldSz(sz);
    }

    @Internal
    public CTPresentation getCTPresentation() {
        return this._presentation;
    }

    public int addPicture(byte[] pictureData, int format) {
        this.getAllPictures();
        int imageNumber = this.getPackage().getPartsByName(Pattern.compile("/ppt/media/.*?")).size() + 1;
        XSLFPictureData img = (XSLFPictureData)this.createRelationship(XSLFPictureData.RELATIONS[format], XSLFFactory.getInstance(), imageNumber, true);
        this._pictures.add(img);
        try {
            OutputStream out = img.getPackagePart().getOutputStream();
            out.write(pictureData);
            out.close();
        }
        catch (IOException e) {
            throw new POIXMLException(e);
        }
        return imageNumber - 1;
    }
}

