/*
 * Decompiled with CFR 0.152.
 */
package com.miraisolutions.xlconnect.integration.r;

import com.miraisolutions.xlconnect.data.DataFrame;
import com.miraisolutions.xlconnect.data.DataType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Vector;

public final class RDataFrameWrapper {
    final DataFrame dataFrame;
    private static final SimpleDateFormat dateTimeParser = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public RDataFrameWrapper() {
        this.dataFrame = new DataFrame();
    }

    public RDataFrameWrapper(DataFrame dataFrame) {
        this.dataFrame = dataFrame;
    }

    public final void addNumericColumn(String name, double[] column, boolean[] na) {
        Double[] elements = new Double[column.length];
        for (int i = 0; i < column.length; ++i) {
            elements[i] = na[i] ? null : new Double(column[i]);
        }
        Vector<Double> v = new Vector<Double>(Arrays.asList(elements));
        this.dataFrame.addColumn(name, DataType.Numeric, v);
    }

    public final void addBooleanColumn(String name, boolean[] column, boolean[] na) {
        Boolean[] elements = new Boolean[column.length];
        for (int i = 0; i < column.length; ++i) {
            elements[i] = na[i] ? null : new Boolean(column[i]);
        }
        Vector<Boolean> v = new Vector<Boolean>(Arrays.asList(elements));
        this.dataFrame.addColumn(name, DataType.Boolean, v);
    }

    public final void addStringColumn(String name, String[] column, boolean[] na) {
        for (int i = 0; i < column.length; ++i) {
            if (!na[i]) continue;
            column[i] = null;
        }
        Vector<String> v = new Vector<String>(Arrays.asList(column));
        this.dataFrame.addColumn(name, DataType.String, v);
    }

    public final void addDateTimeColumn(String name, String[] column, boolean[] na) throws ParseException {
        Date[] elements = new Date[column.length];
        for (int i = 0; i < column.length; ++i) {
            elements[i] = na[i] ? null : dateTimeParser.parse(column[i]);
        }
        Vector<Date> v = new Vector<Date>(Arrays.asList(elements));
        this.dataFrame.addColumn(name, DataType.DateTime, v);
    }

    public final String[] getColumnTypes() {
        Vector<DataType> columnTypes = this.dataFrame.getColumnTypes();
        String[] dataTypes = new String[columnTypes.size()];
        for (int i = 0; i < columnTypes.size(); ++i) {
            dataTypes[i] = columnTypes.get(i).toString();
        }
        return dataTypes;
    }

    public final String[] getColumnNames() {
        Vector<String> vector = this.dataFrame.getColumnNames();
        return vector.toArray(new String[vector.size()]);
    }

    public final double[] getNumericColumn(int n) {
        Vector vector = this.dataFrame.getColumn(n);
        double[] dArray = new double[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            Double d = (Double)vector.get(i);
            dArray[i] = d == null ? 0.0 : d;
        }
        return dArray;
    }

    public final String[] getStringColumn(int n) {
        Vector vector = this.dataFrame.getColumn(n);
        return vector.toArray(new String[vector.size()]);
    }

    public final boolean[] getBooleanColumn(int n) {
        Vector vector = this.dataFrame.getColumn(n);
        boolean[] blArray = new boolean[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            Boolean bl = (Boolean)vector.get(i);
            blArray[i] = bl == null ? false : bl;
        }
        return blArray;
    }

    public final String[] getDateTimeColumn(int n) {
        Vector vector = this.dataFrame.getColumn(n);
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            Date date = (Date)vector.get(i);
            stringArray[i] = date == null ? null : dateTimeParser.format(date);
        }
        return stringArray;
    }

    public final boolean[] isMissing(int n) {
        Vector vector = this.dataFrame.getColumn(n);
        boolean[] blArray = new boolean[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            blArray[i] = vector.get(i) == null;
        }
        return blArray;
    }
}

