% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xAuxFunArgs.r
\name{xAuxFunArgs}
\alias{xAuxFunArgs}
\title{Function to assign (and evaluate) arguments with default values for a given function}
\usage{
xAuxFunArgs(fun, action = NULL, verbose = TRUE)
}
\arguments{
\item{fun}{character specifying the name of the function}

\item{action}{logical to indicate whether the function will act as it
should be (with assigned values in the current environment). By
default, it sets to NULL, return a string specifying the assignment to
be evalated}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to TRUE for display}
}
\value{
If action is logical, a list containing arguments and their default
values. If action is NULL, a string specifying the assignment to be
evalated.
}
\description{
\code{xAuxFunArgs} is supposed to assign (and evaluate) arguments with
default values for a given function.
}
\note{
This auxiliary function is potentially useful when debugging as it
frees developers from specifying default values for all arguments
except those arguments of interest
}
\examples{
xAuxFunArgs(fun="xRDataLoader")
}
\seealso{
\code{\link{xAuxFunArgs}}
}
