% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xVisInterp.r
\name{xVisInterp}
\alias{xVisInterp}
\title{Function to visualise interpolated irregular data}
\usage{
xVisInterp(ls_xyz, interpolation = c("spline", "linear"), nx = 100,
ny = 100, zlim = NULL, nD = c("auto", "2D", "3D"), colkey = TRUE,
contour = FALSE, image = FALSE, clab = c("Value", ""), nlevels = 20,
colormap = "terrain", label.pch = 17, label.text.cex = 0.8,
label.text.adj = -0.4, label.text.adj.z = 0.01,
label.font.family = "sans", xy.swap = FALSE, theta.3D = 40,
phi.3D = 20, verbose = TRUE)
}
\arguments{
\item{ls_xyz}{a list with 3 required components (x, y and z) and an
optional component (label)}

\item{interpolation}{the method for the interpolation. It can be
"linear" or "spline" interpolation}

\item{nx}{the dimension of output grid in x direction}

\item{ny}{the dimension of output grid in y direction}

\item{zlim}{the minimum and maximum z values, defaulting to the range
of the finite values of z}

\item{nD}{an integer specifying the dimension of the visualisation. It
can be one of '2D', '3D', and 'auto' (to display the input raw data as
well in 2D)}

\item{colkey}{a logical (TRUE by default) or a 'list' with parameters
for the color key (legend). List parameters should be one of 'side,
plot, length, width, dist, shift, addlines, col.clab, cex.clab,
side.clab, line.clab, adj.clab, font.clab'. The defaults for the
parameters are 'side=4, plot=TRUE, length=1, width=1, dist=0, shift=0,
addlines=FALSE, col.clab=NULL, cex.clab=par("cex.lab"), side.clab=NULL,
line.clab=NULL, adj.clab=NULL, font.clab=NULL'.
colkey=list(side=4,length=0.15,width=0.5,shift=0.35,dist=-0.15,cex.axis=0.6,cex.clab=0.8,side.clab=3)}

\item{contour}{a logical (FALSE by default) or a 'list' with parameters
for the contour function. An optional parameter to this 'list' is the
'side' where the image should be plotted. Allowed values for 'side' are
a z-value, or 'side = "zmin", "zmax"', for positioning at bottom or top
respectively. The default is to put the image at the bottom}

\item{image}{a logical (FALSE by default) or a 'list' with parameters
for the image2D function. An optional parameter to this 'list' is the
'side' where the image should be plotted. Allowed values for 'side' are
a z-value, or 'side = "zmin", "zmax"', for positioning at bottom or top
respectively. The default is to put the image at the bottom}

\item{clab}{a title for the colorbar. the label to be written on top of
the color key; to lower it, 'clab' can be made a vector, with the first
values empty strings.}

\item{nlevels}{the number of levels to partition the input matrix
values. The same level has the same color mapped to}

\item{colormap}{short name for the colormap. It can be one of "jet"
(jet colormap), "bwr" (blue-white-red colormap), "gbr" (green-black-red
colormap), "wyr" (white-yellow-red colormap), "br" (black-red
colormap), "yr" (yellow-red colormap), "wb" (white-black colormap), and
"rainbow" (rainbow colormap, that is,
red-yellow-green-cyan-blue-magenta). Alternatively, any
hyphen-separated HTML color names, e.g. "blue-black-yellow",
"royalblue-white-sandybrown", "darkgreen-white-darkviolet". A list of
standard color names can be found in
\url{http://html-color-codes.info/color-names}}

\item{label.pch}{a numeric value specifying the graphiics symbol (by
default, 17 for upward triangle). This argument only works when the
labelling is enabled}

\item{label.text.cex}{a numeric value specifying the text size. This
argument only works when the labelling is enabled}

\item{label.text.adj}{a numeric value adjusting the text location in
xy-plane. This argument only works when the labelling is enabled}

\item{label.text.adj.z}{a numeric value adjusting the text locaion in
z-axis. This argument only works when the labelling is enabled}

\item{label.font.family}{the font family for texts. This argument only
works when the labelling is enabled}

\item{xy.swap}{logical to indicate whether to wrap x and y. By default,
it sets to false}

\item{theta.3D}{the azimuthal direction. By default, it is 40}

\item{phi.3D}{the colatitude direction. By default, it is 20}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to true for display}
}
\value{
invisible
}
\description{
\code{xVisInterp} is supposed to visualise irregular data after
bilinear or bicubic spline interpolation onto a grid.
}
\note{
none
}
\examples{
\dontrun{
library(XGR)
}
RData.location <- "http://galahad.well.ox.ac.uk/bigdata"
\dontrun{
g <- erdos.renyi.game(20, 1/10)
glayout <- layout_with_kk(g)
ls_xyz <- data.frame(x=glayout[,1], y=glayout[,2], z=degree(g),
label=degree(g))

# auto
ls_xyz.smooth <- xVisInterp(ls_xyz, nD="auto")
# 2D
ls_xyz.smooth <- xVisInterp(ls_xyz, nD="2D")
# 3D
xVisInterp(ls_xyz, nD="3D", theta.3D=40, phi.3D=20, clab="Value\\n")
# 3D views of different angles
pdf("xVisInterp.pdf")
for(theta.3D in seq(0,360,10)){ xVisInterp(ls_xyz, nD="3D",
contour=TRUE, image=TRUE, clab=paste0("theta:",theta.3D,"\\n"),
theta.3D=theta.3D, phi.3D=20)}
dev.off()
}
}
\seealso{
\code{\link{xVisInterp}}
}
