% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{xdnuts}
\alias{xdnuts}
\title{Discontinuous Hamiltonian Monte Carlo using both manual and automatic termination criteria.}
\usage{
xdnuts(
  theta0,
  nlp,
  args,
  k,
  N = 1000,
  K = 3,
  method = "NUTS",
  tau = NULL,
  L = NULL,
  thin = 1,
  control = set_parameters(),
  parallel = FALSE,
  loadLibraries = NULL,
  loadRObject = NULL,
  verbose = FALSE,
  hide = FALSE,
  logfile = ""
)
}
\arguments{
\item{theta0}{a list containing the starting values for each chain. These starting values are vectors of length-\eqn{d}. 
The last \eqn{k \in [0,d]} elements refer to parameters which determine a discontinuity in the posterior distribution.}

\item{nlp}{a function which evaluates the negative log posterior and its gradient with respect to 
parameters that do not induce any discontinuity in the posterior distribution (more generally, the first \eqn{d-k} parameters).
This function must take 3 arguments:
\describe{
\item{par}{a vector of length-\eqn{d} containing the parameter values.}
\item{args}{a list object that contains the necessary arguments, namely data and hyperparameters.}
\item{eval_nlp}{a boolean value, \code{TRUE} to evaluate only the negative log posterior of the models, 
\code{FALSE} to evaluate its gradient with respect to the continuous components of the posterior.}
}}

\item{args}{a list containing the inputs for the negative posterior function.}

\item{k}{an integer value that states the number of parameters that determines a discontinuity in the posterior distribution.
Actually, since the algorithm proposed in \insertCite{nishimura2020discontinuous}{XDNUTS} also works for the full continuous case,
\code{k} is the number of parameters specified by the user for which this algorithm is used.}

\item{N}{the number of draws from the posterior distribution, after warm-up, for each chain. Default value is \code{1000}.}

\item{K}{the number of recycled samples per iteration used by default during the warm-up phase.
Default value is \code{3}. To recycle in the sampling phase too, specify \code{recycle_only_init = FALSE}
in the \code{control} argument above.}

\item{method}{a character value which defines the type of algorithm to exploit:\describe{
\item{\code{"NUTS"}}{applies the No U-Turn Sampler of \insertCite{hoffman2014no}{XDNUTS}.}
\item{\code{"XHMC"}}{applies the Exhaustion Hamiltonian Monte Carlo of \insertCite{betancourt2016identifying}{XDNUTS}.}
\item{\code{"HMC"}}{applies one of the classic version of Hamiltonian Monte Carlo algorithm,
in particular the one described in \insertCite{betancourt2017conceptual}{XDNUTS}, which samples from the trajectory instead of always returning the last value.}
}}

\item{tau}{the threshold for the virial termination criterion \insertCite{betancourt2016identifying}{XDNUTS}.}

\item{L}{the desired length of the trajectory of classic Hamiltonian Monte Carlo algorithm.}

\item{thin}{the number of necessary and discarded samples to obtain a final iteration of one chain.}

\item{control}{an object of class \code{control_xdnuts}, output of the function \link{set_parameters}.}

\item{parallel}{a boolean value specifying whether the chains must be run in parallel. Default value is \code{FALSE}.}

\item{loadLibraries}{A character vector indicating the names of the packages to load on each cluster if
\code{parallel} is set to \code{TRUE}.}

\item{loadRObject}{A character vector indicating the names of the R objects to load on each cluster if
\code{parallel} is set to \code{TRUE}.}

\item{verbose}{a boolean value for printing all the information regarding the sampling process.}

\item{hide}{a boolean value that omits the printing to the console if set to \code{TRUE}.}

\item{logfile}{The pathname of the log file. The default value is \code{""}. 
On Linux or macOS systems, this allows the output to be printed directly to the console. 
Unfortunately, this is not possible on Windows systems.}
}
\value{
a list of class \code{XDNUTS} containing \describe{
\item{chains}{a list of the same length of \code{theta0}, each element containing the output from the function \link{main_function}.}
\item{d}{the dimension of the parameter space.}
\item{k}{the number of parameters that lead to a discontinuous posterior distribution. 
Or, more generally, for which the algorithm of \insertCite{nishimura2020discontinuous}{XDNUTS} is exploited.}
\item{K}{the number of recycled samples for each iteration during the sampling phase.}
\item{N}{the number of posterior draws for each chain.}
\item{method}{the MCMC method used. This could be either "NUTS", "XHMC", or "HMC".}
\item{tau}{the threshold for the virial termination criterion \insertCite{betancourt2016identifying}{XDNUTS}. 
Only if \code{method = "XHMC"} this value is different from zero.}
\item{L}{the desired length of the trajectory of classic Hamiltonian Monte Carlo algorithm specified by the user.
This argument is necessary if \code{method = "HMC"}.}
\item{thin}{the number of discarded samples for every final iteration, specified by the user.}
\item{control}{an object of class \code{control_xdnuts}, output of the function \link{set_parameters} with arguments specified by the user.}
\item{verbose}{the boolean value specified by the user regarding the printing of the sampling process information.}
\item{parallel}{the boolean value specified by the user regarding parallel processing.}
}
}
\description{
The function allows generating multiple Markov Chains for sampling from both continuous and discontinuous
posterior distributions using a variety of algorithms. Classic Hamiltonian Monte Carlo \insertCite{duane1987hybrid}{XDNUTS}, 
NUTS \insertCite{hoffman2014no}{XDNUTS}, and XHMC \insertCite{betancourt2016identifying}{XDNUTS} are embedded into the framework
described in \insertCite{nishimura2020discontinuous}{XDNUTS}, which allows dealing with such posteriors.
Furthermore, for each method, it is possible to recycle samples from the trajectories using
the method proposed by \insertCite{Nishimura_2020}{XDNUTS}.
This is used to improve the estimate of the Mass Matrix during the warm-up phase
without requiring a relevant additional computational cost.
}
\references{
\insertAllCited{}
}
