% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{xdextract}
\alias{xdextract}
\title{Function to extract samples from the output of an XDNUTS model.}
\usage{
xdextract(X, which = NULL, which_chains = NULL, collapse = FALSE)
}
\arguments{
\item{X}{an object of class \code{XDNUTS}.}

\item{which}{either a numerical vector indicating the index of the parameters of interest or a string \describe{
\item{\code{which = 'continuous'}}{for plotting the first \eqn{d-k} parameters.}
\item{\code{which = 'discontinuous'}}{for plotting the last \eqn{k} parameters.}
}
where both \eqn{d} and \eqn{k} are elements contained in the output of the function \link{xdnuts}.}

\item{which_chains}{a vector of indices containing the chains to extract. By default, all chains are considered.}

\item{collapse}{a boolean value. If TRUE, all samples from every chain are collapsed into one. The default value is FALSE.}
}
\value{
an \eqn{N \times d} matrix or an \eqn{N \times d \times C} array, where C is the number of chains, containing the MCMC samples.
}
\description{
Function to extract samples from the output of an XDNUTS model.
}
