% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{L1_method_options}
\alias{L1_method_options}
\title{Options For Use With the L1 Method}
\usage{
L1_method_options(
  penalty = L1_penalty_options(),
  lambda = numeric(0),
  nlambda = 500L,
  lambda.min.ratio = 1e-04,
  gamma = 1,
  maxit = 500L,
  model.size = NULL,
  tol = 1e-07,
  display.progress = FALSE,
  solver.options = NULL
)
}
\arguments{
\item{penalty}{The penalty to use. See \code{\link[=L1_penalty_options]{L1_penalty_options()}} for more details.}

\item{lambda}{The penalty parameter to use if method is "L1".}

\item{nlambda}{The number of lambdas to explore for the "L1" method if \code{lambda} is not provided}

\item{lambda.min.ratio}{The minimum ratio of max to min lambda for "L1" method. Default 1e-4.}

\item{gamma}{Tuning parameter for SCAD and MCP penalties if method = "L1".}

\item{maxit}{The maximum iterations for optimization. Default is 500.}

\item{model.size}{What is the maximum number of coefficients to have in the final model. Default is NULL. If NULL, will find models from the minimum size, 0, to the number of columns in \code{X}.}

\item{tol}{The tolerance for convergence}

\item{display.progress}{Logical. Should intermediate progress be displayed? TRUE or FALSE. Default is FALSE.}

\item{solver.options}{Options to be passed on to the solver. Only used for "ecos" and "mosek" solvers.}
}
\value{
A list with names corresponding to each argument above.
}
\description{
Options For Use With the L1 Method
}
\examples{
L1_method_options()
}
\seealso{
\code{\link[=WpProj]{WpProj()}}
}
