% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialRt.R
\name{spatialRt}
\alias{spatialRt}
\title{Run Spatial R(t) estimation and Estimate Reproduction Numbers}
\usage{
spatialRt(report_dates, case_matrix, transfer_matrix, sip, v2 = FALSE, ...)
}
\arguments{
\item{report_dates}{A vector of reporting dates}

\item{case_matrix}{A matrix of cases, defined by integers}

\item{transfer_matrix}{A matrix that defines how infectors flow between states.
Each row of the transfer matrix must sum to 1.}

\item{sip}{Vector of numeric values specifying the serial interval probabilities.}

\item{v2}{a flag indicating FALSE if the base algorithm is to be used, and TRUE if
the experimental algorithm is desired. The experimental version contains a
non-centered parameterization, an AR1 process, and partial pooling across states.}

\item{...}{Additional arguments passed to rstan::sampling()}
}
\value{
An rstan object.
}
\description{
This function calculates R(t) that arises from transfer of infectors between
different states. There are different flavors of the model, but the base version
calculates a weekly R(t) within each state.
}
\examples{
\donttest{
data("sample_multi_site")
data("transfer_matrix")
Y <- matrix(integer(1), nrow = nrow(sample_multi_site), ncol = 2)
for(i in 1:nrow(Y)) {
  for(j in c(2, 3)) {
    Y[i,j-1] <- as.integer(sample_multi_site[i,j])
  }
}
all(is.integer(Y))
sip <- si(14, 4.29, 1.18, leading0 = FALSE)
sample_m_hier <- spatialRt(report_dates = sample_multi_site$date,
case_matrix = Y,
transfer_matrix = transfer_matrix,
v2 = FALSE,
sip = sip, chains = 1)
}
}
